/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.AuthenticationType;
import com.eclipsesource.restfuse.MediaType;
import com.eclipsesource.restfuse.annotation.Authentication;
import com.eclipsesource.restfuse.annotation.Header;
import com.eclipsesource.restfuse.annotation.HttpTest;
import com.eclipsesource.restfuse.internal.AuthenticationInfo;
import com.eclipsesource.restfuse.internal.InternalRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.junit.runners.model.FrameworkMethod;

public class RequestConfiguration {
    private static final String PATH_SEPARATOR = "/";
    private final String baseUrl;
    private final FrameworkMethod method;
    private final Object target;

    public RequestConfiguration(String baseUrl, FrameworkMethod method, Object target) {
        this.baseUrl = baseUrl;
        this.method = method;
        this.target = target;
    }

    public InternalRequest createRequest() {
        HttpTest call = (HttpTest)this.method.getAnnotation(HttpTest.class);
        InternalRequest request = new InternalRequest(this.combineUrlAndPath(this.baseUrl, call.path()));
        this.addAuthentication(call, request);
        this.addContentType(call, request);
        this.addHeader(call, request);
        this.addBody(call, request);
        return request;
    }

    private void addAuthentication(HttpTest call, InternalRequest request) {
        Authentication[] authentications = call.authentications();
        if (authentications != null) {
            Authentication[] authenticationArray = authentications;
            int n = authentications.length;
            int n2 = 0;
            while (n2 < n) {
                Authentication authentication = authenticationArray[n2];
                AuthenticationType type = authentication.type();
                String user = authentication.user();
                String password = authentication.password();
                request.addAuthenticationInfo(new AuthenticationInfo(type, user, password));
                ++n2;
            }
        }
    }

    private void addContentType(HttpTest call, InternalRequest request) {
        MediaType contentType = call.type();
        if (contentType != null) {
            request.setContentType(contentType.getMimeType());
        }
    }

    private void addHeader(HttpTest call, InternalRequest request) {
        Header[] header = call.headers();
        if (header != null) {
            Header[] headerArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                Header parameter = headerArray[n2];
                request.addHeader(parameter.name(), parameter.value());
                ++n2;
            }
        }
    }

    private void addBody(HttpTest test, InternalRequest request) {
        if (!test.file().equals("")) {
            request.setContent(this.getFileStream(test.file()));
        } else if (!test.content().equals("")) {
            request.setContent(this.getContentStream(test.content()));
        }
    }

    private InputStream getFileStream(String file) {
        URL resource = this.target.getClass().getResource(file);
        try {
            return resource.openStream();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not open file " + file + ". Maybe it's not on the classpath?");
        }
    }

    private InputStream getContentStream(String content) {
        try {
            return new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException shouldNotHappen) {
            throw new IllegalStateException(shouldNotHappen);
        }
    }

    private String combineUrlAndPath(String url, String pathValue) {
        String result;
        if (url.endsWith(PATH_SEPARATOR) && pathValue.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(url) + pathValue.substring(1, pathValue.length());
        } else if (!url.endsWith(PATH_SEPARATOR) && pathValue.startsWith(PATH_SEPARATOR) || url.endsWith(PATH_SEPARATOR) && !pathValue.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(url) + pathValue;
        } else if (!url.endsWith(PATH_SEPARATOR) && !pathValue.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(url) + PATH_SEPARATOR + pathValue;
        } else {
            throw new IllegalStateException("Invalid url format with base url " + url + " and path " + pathValue);
        }
        return result;
    }
}

