/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal.poll;

import com.eclipsesource.restfuse.PollState;
import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.annotation.Context;
import com.eclipsesource.restfuse.annotation.Poll;
import com.eclipsesource.restfuse.internal.HttpTestStatement;
import com.eclipsesource.restfuse.internal.poll.PollStateImpl;
import java.lang.reflect.Field;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class PollStatement
extends Statement {
    private final Statement statement;
    private final HttpTestStatement base;
    private int interval;
    private int times;
    private final Object target;
    private PollStateImpl pollState;

    public PollStatement(Statement statement, HttpTestStatement base, FrameworkMethod method, Object target) {
        this.statement = statement;
        this.base = base;
        this.target = target;
        Poll pollAnnotation = (Poll)method.getAnnotation(Poll.class);
        this.interval = pollAnnotation.interval();
        this.times = pollAnnotation.times();
        this.pollState = new PollStateImpl();
    }

    public void evaluate() throws Throwable {
        int i = 0;
        while (i < this.times && !this.pollState.wasAborted()) {
            this.doSingleEvaluate();
            ++i;
        }
    }

    private void doSingleEvaluate() throws Throwable {
        Response response = this.base.sendRequest();
        this.base.tryInjectResponse(response);
        this.tryToInjectPollState(response);
        this.statement.evaluate();
        this.sleep();
    }

    private void tryToInjectPollState(Response response) {
        Field[] fields;
        this.pollState.addResponse(response);
        Field[] fieldArray = fields = this.target.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Context contextAnnotation = field.getAnnotation(Context.class);
            if (contextAnnotation != null && field.getType() == PollState.class) {
                this.injectPollState(field);
            }
            ++n2;
        }
    }

    private void injectPollState(Field field) {
        field.setAccessible(true);
        try {
            field.set(this.target, this.pollState);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not inject pollstate.", exception);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException shouldNotHappen) {
            throw new IllegalStateException("Could not sleep until the next poll", shouldNotHappen);
        }
    }
}

