/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse;

import com.eclipsesource.restfuse.annotation.HttpTest;
import com.eclipsesource.restfuse.internal.HttpTestStatement;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class Destination
implements MethodRule {
    private HttpTestStatement requestStatement;
    private final String baseUrl;

    public Destination(String baseUrl) {
        this.checkBaseUrl(baseUrl);
        this.baseUrl = baseUrl;
    }

    private void checkBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl must not be null");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("baseUrl has to be an URL");
        }
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Statement result;
        if (this.hasAnnotation(method)) {
            this.requestStatement = new HttpTestStatement(base, method, target, this.baseUrl);
            result = this.requestStatement;
        } else {
            result = base;
        }
        return result;
    }

    private boolean hasAnnotation(FrameworkMethod method) {
        return method.getAnnotation(HttpTest.class) != null;
    }
}

