/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse;

public enum MediaType {
    WILDCARD("*/*"),
    APPLICATION_XML("application/xml"),
    APPLICATION_ATOM_XML("application/atom+xml"),
    APPLICATION_XHTML_XML("application/xhtml+xml"),
    APPLICATION_SVG_XML("application/svg+xml"),
    APPLICATION_JSON("application/json"),
    APPLICATION_FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART_FORM_DATA("multipart/form-data"),
    APPLICATION_OCTET_STREAM("application/octet-stream"),
    TEXT_PLAIN("text/plain"),
    TEXT_XML("text/xml"),
    TEXT_HTML("text/html");

    private final String mimeType;

    private MediaType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static MediaType fromString(String type) {
        MediaType[] values;
        MediaType result = null;
        MediaType[] mediaTypeArray = values = MediaType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType value = mediaTypeArray[n2];
            if (value.getMimeType().equals(type)) {
                result = value;
            }
            ++n2;
        }
        return result;
    }

    public String toString() {
        return this.mimeType;
    }
}

