/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse;

import com.eclipsesource.restfuse.MediaType;
import com.eclipsesource.restfuse.Request;
import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CallbackResource {
    static Response createResponse(Status status, MediaType contentType, String body, Map<String, List<String>> headers) {
        return new CallbackResponse(status, contentType, body, headers);
    }

    public abstract Response get(Request var1);

    public abstract Response post(Request var1);

    public abstract Response put(Request var1);

    public abstract Response delete(Request var1);

    public abstract Response head(Request var1);

    public abstract Response options(Request var1);

    private static class CallbackResponse
    implements Response {
        private final Status status;
        private final MediaType contentType;
        private final String body;
        private final Map<String, List<String>> headers;

        public CallbackResponse(Status status, MediaType contentType, String body, Map<String, List<String>> headers) {
            this.status = status;
            this.contentType = contentType;
            this.body = body;
            this.headers = headers;
        }

        @Override
        public boolean hasBody() {
            return this.body != null;
        }

        @Override
        public <T> T getBody(Class<T> type) {
            if (type != String.class) {
                throw new IllegalStateException("CallbackResponse can only have Strings as body");
            }
            return (T)this.body;
        }

        @Override
        public MediaType getType() {
            return this.contentType;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            HashMap<String, List<String>> result = null;
            if (this.headers != null) {
                result = new HashMap<String, List<String>>(this.headers);
            }
            return result;
        }

        @Override
        public int getStatus() {
            return this.status.getStatusCode();
        }
    }
}

