/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.Method;
import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.annotation.Callback;
import com.eclipsesource.restfuse.annotation.Context;
import com.eclipsesource.restfuse.annotation.HttpTest;
import com.eclipsesource.restfuse.annotation.Poll;
import com.eclipsesource.restfuse.internal.BasicStatement;
import com.eclipsesource.restfuse.internal.InternalRequest;
import com.eclipsesource.restfuse.internal.RequestConfiguration;
import com.eclipsesource.restfuse.internal.ResponseImpl;
import com.eclipsesource.restfuse.internal.callback.CallbackStatement;
import com.eclipsesource.restfuse.internal.poll.PollStatement;
import com.sun.jersey.api.client.ClientResponse;
import java.lang.reflect.Field;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class HttpTestStatement
extends Statement {
    private final Statement base;
    private final FrameworkMethod method;
    private final Object target;
    private final String baseUrl;

    public HttpTestStatement(Statement base, FrameworkMethod method, Object target, String baseUrl) {
        this.base = base;
        this.method = method;
        this.target = target;
        this.baseUrl = baseUrl;
    }

    public void evaluate() throws Throwable {
        Statement delegate = new BasicStatement(this.base, this);
        if (this.needsCallback()) {
            delegate = new CallbackStatement(this.base, this, this.method, this.target);
        } else if (this.needsPoll()) {
            delegate = new PollStatement(this.base, this, this.method, this.target);
        }
        delegate.evaluate();
    }

    private boolean needsCallback() {
        Callback callbackAnnotation = (Callback)this.method.getAnnotation(Callback.class);
        return callbackAnnotation != null;
    }

    private boolean needsPoll() {
        Poll pollAnnotation = (Poll)this.method.getAnnotation(Poll.class);
        return pollAnnotation != null;
    }

    public Response sendRequest() {
        InternalRequest request = this.buildRequest();
        ClientResponse clientResponse = this.callService(request);
        return new ResponseImpl(clientResponse);
    }

    private InternalRequest buildRequest() {
        RequestConfiguration requestConfiguration = new RequestConfiguration(this.baseUrl, this.method, this.target);
        return requestConfiguration.createRequest();
    }

    private ClientResponse callService(InternalRequest request) {
        Method requestMethod = ((HttpTest)this.method.getAnnotation(HttpTest.class)).method();
        ClientResponse result = null;
        if (requestMethod.equals((Object)Method.GET)) {
            result = request.get();
        } else if (requestMethod.equals((Object)Method.POST)) {
            result = request.post();
        } else if (requestMethod.equals((Object)Method.DELETE)) {
            result = request.delete();
        } else if (requestMethod.equals((Object)Method.PUT)) {
            result = request.put();
        } else if (requestMethod.equals((Object)Method.HEAD)) {
            result = request.head();
        } else if (requestMethod.equals((Object)Method.OPTIONS)) {
            result = request.options();
        }
        return result;
    }

    public void tryInjectResponse(Response response) {
        Field[] fields;
        Field[] fieldArray = fields = this.target.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Context contextAnnotation = field.getAnnotation(Context.class);
            if (contextAnnotation != null && field.getType() == Response.class) {
                this.injectResponse(field, response);
            }
            ++n2;
        }
    }

    private void injectResponse(Field field, Response response) {
        field.setAccessible(true);
        try {
            field.set(this.target, response);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not inject response.", exception);
        }
    }
}

