/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.AuthenticationType;
import com.eclipsesource.restfuse.internal.AuthenticationInfo;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.HTTPDigestAuthFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalRequest {
    private final Map<String, List<String>> headers;
    private final List<AuthenticationInfo> authentications;
    private final String url;
    private InputStream content;
    private String mediaType;

    public InternalRequest(String url) {
        this.url = url;
        this.headers = new HashMap<String, List<String>>();
        this.authentications = new ArrayList<AuthenticationInfo>();
    }

    public void setContentType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public void addHeader(String name, String value) {
        List<String> param = this.headers.get(name);
        if (param == null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(value);
            this.headers.put(name, params);
        } else {
            param.add(value);
        }
    }

    public void addAuthenticationInfo(AuthenticationInfo authentication) {
        this.authentications.add(authentication);
    }

    public ClientResponse get() {
        ClientResponse result;
        try {
            result = (ClientResponse)this.createRequest().get(ClientResponse.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public ClientResponse post() {
        ClientResponse result;
        try {
            result = (ClientResponse)this.createRequest().post(ClientResponse.class, (Object)this.content);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public ClientResponse delete() {
        ClientResponse result;
        try {
            result = (ClientResponse)this.createRequest().delete(ClientResponse.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public ClientResponse put() {
        ClientResponse result;
        try {
            result = (ClientResponse)this.createRequest().put(ClientResponse.class, (Object)this.content);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public ClientResponse head() {
        ClientResponse result;
        try {
            result = this.createRequest().head();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public ClientResponse options() {
        ClientResponse result;
        try {
            result = (ClientResponse)this.createRequest().options(ClientResponse.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private WebResource.Builder createRequest() {
        Client client = Client.create();
        this.addAuthentication(client);
        WebResource resource = client.resource(this.url);
        String type = this.mediaType != null ? this.mediaType : "*/*";
        WebResource.Builder builder = resource.type(type);
        builder = this.addHeaders(builder);
        return builder;
    }

    private void addAuthentication(Client client) {
        for (AuthenticationInfo authentication : this.authentications) {
            HTTPBasicAuthFilter filter = null;
            if (authentication.getType().equals((Object)AuthenticationType.BASIC)) {
                filter = new HTTPBasicAuthFilter(authentication.getUser(), authentication.getPassword());
            } else if (authentication.getType().equals((Object)AuthenticationType.DIGEST)) {
                filter = new HTTPDigestAuthFilter(authentication.getUser(), authentication.getPassword());
            }
            client.addFilter((ClientFilter)filter);
        }
    }

    private WebResource.Builder addHeaders(WebResource.Builder builder) {
        WebResource.Builder result = builder;
        Set<String> keySet = this.headers.keySet();
        for (String key : keySet) {
            List<String> values = this.headers.get(key);
            for (String value : values) {
                result = (WebResource.Builder)result.header(key, (Object)value);
            }
        }
        return result;
    }
}

