/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal.callback;

import com.eclipsesource.restfuse.CallbackResource;
import com.eclipsesource.restfuse.annotation.Callback;
import com.eclipsesource.restfuse.internal.callback.CallbackSerlvet;
import com.eclipsesource.restfuse.internal.callback.CallbackStatement;
import java.lang.reflect.Constructor;
import javax.servlet.Servlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class CallbackServer {
    private CallbackResource resource;
    private int timeout;
    private int port;
    private String path;
    private Server server;
    private CallbackSerlvet servlet;
    private final CallbackStatement statement;

    public CallbackServer(Callback callbackAnnotation, Object target, CallbackStatement callbackStatement) {
        this.createResource(callbackAnnotation.resource(), target);
        this.statement = callbackStatement;
        this.timeout = callbackAnnotation.timeout();
        this.port = callbackAnnotation.port();
        this.path = callbackAnnotation.path();
    }

    private void createResource(Class<? extends CallbackResource> type, Object target) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(target.getClass().getClassLoader());
            this.doCreateResource(type, target);
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    private void doCreateResource(Class<? extends CallbackResource> type, Object target) {
        try {
            Constructor<? extends CallbackResource> constructor = type.getDeclaredConstructor(target.getClass());
            constructor.setAccessible(true);
            this.resource = constructor.newInstance(target);
        }
        catch (Exception exception) {
            try {
                Constructor<? extends CallbackResource> constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.resource = constructor.newInstance(new Object[0]);
            }
            catch (Exception shouldNotHappen) {
                throw new IllegalStateException("Could not create resource instance of type " + type.getName() + ". Is there an default constructor?", shouldNotHappen);
            }
        }
    }

    public void start() {
        this.configureServer();
        this.doStartServer();
    }

    private void configureServer() {
        this.server = new Server(this.port);
        Context context = new Context((HandlerContainer)this.server, "/", 1);
        this.servlet = new CallbackSerlvet(this.resource, this.statement);
        context.addServlet(new ServletHolder((Servlet)this.servlet), this.path);
    }

    private void doStartServer() {
        try {
            this.server.start();
        }
        catch (Exception shouldNotHappen) {
            throw new IllegalStateException("Could not start Http Server", shouldNotHappen);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception shouldNotHappen) {
            throw new IllegalStateException("Could not stop Http Server", shouldNotHappen);
        }
    }

    public boolean wasCalled() {
        return this.servlet.wasCalled();
    }

    public int getTimeout() {
        return this.timeout;
    }
}

