/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileHandler {
    String fileSuffix = ".eml";
    String filePrefix = "mail-";
    String tmpFilePrefix = "tmp-";
    BufferedWriter mailFileWriter;
    File inboxDir;
    File tempFile;
    private static final Logger LOGGER = Logger.getLogger(FileHandler.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public FileHandler(String inboxPath) throws IOException {
        this.inboxDir = new File(inboxPath);
        this.tempFile = File.createTempFile(this.filePrefix, null, this.inboxDir);
        FileWriter fWriter = new FileWriter(this.tempFile);
        this.mailFileWriter = new BufferedWriter(fWriter);
    }

    public void done() throws IOException {
        this.mailFileWriter.flush();
        this.mailFileWriter.close();
        File outFile = File.createTempFile(this.filePrefix, this.fileSuffix, this.inboxDir);
        String outfileName = outFile.getAbsolutePath();
        this.tempFile.renameTo(outFile);
        if (this.debugEnabled) {
            LOGGER.debug((Object)("Mail written to outfile " + outfileName));
        }
    }

    public void destroy() throws IOException {
        this.mailFileWriter.flush();
        this.mailFileWriter.close();
        this.tempFile.delete();
    }

    public void put(String line) throws IOException {
        this.mailFileWriter.write(line);
    }
}

