/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import de.lwsystems.mailarchive.input.FileHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;

public class SmtpHandler
implements MessageHandlerFactory {
    private static final Logger LOGGER = Logger.getLogger(SmtpHandler.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    public static String CRLF = "\r\n";
    public static String rcpttoHeader = "X-REAL-RCPTTO: ";
    public static String mailFromHeader = "X-REAL-MAILFROM: ";
    public static String inboxDir;

    public MessageHandler create(MessageContext ctx) {
        return new Handler(ctx);
    }

    class Handler
    implements MessageHandler {
        MessageContext ctx;
        private FileHandler mailFile;
        private int smtpStatus = 0;

        public Handler(MessageContext ctx) {
            this.ctx = ctx;
        }

        public void from(String sender) throws RejectException {
            try {
                this.mailFile = new FileHandler(inboxDir);
                if (SmtpHandler.this.debugEnabled) {
                    LOGGER.debug((Object)("Add sender header " + mailFromHeader + sender + CRLF));
                }
                this.mailFile.put(mailFromHeader + sender + CRLF);
                ++this.smtpStatus;
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Cannot add sender header to output file", (Throwable)ex);
                throw new RejectException(451, "Cannot write output file");
            }
        }

        public void recipient(String recipient) throws RejectException {
            try {
                if (SmtpHandler.this.debugEnabled) {
                    LOGGER.debug((Object)("Add recipient header " + rcpttoHeader + recipient + CRLF));
                }
                this.mailFile.put(rcpttoHeader + recipient + CRLF);
                ++this.smtpStatus;
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Cannot add from header recipient output file", (Throwable)ex);
                throw new RejectException(451, "Cannot write output file");
            }
        }

        public void data(InputStream data) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(data));
            StringBuilder sb = new StringBuilder();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    this.mailFile.put(line + CRLF);
                }
                ++this.smtpStatus;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void done() throws RejectException {
            try {
                if (this.smtpStatus < 3) {
                    this.mailFile.destroy();
                } else {
                    this.mailFile.done();
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Cannot close output file", (Throwable)ex);
                throw new RejectException(451, "Cannot close output file");
            }
        }
    }
}

