/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileHandler {
    String fileSuffix = ".eml";
    String filePrefix = "mail-";
    String tmpFilePrefix = "tmp-";
    File inboxDir;
    File tempFile;
    FileOutputStream mailOutputStream;
    BufferedWriter mailFileWriter;
    private static final Logger LOGGER = Logger.getLogger(FileHandler.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public FileHandler(String inboxPath) throws IOException {
        this.inboxDir = new File(inboxPath);
        this.tempFile = File.createTempFile(this.filePrefix, null, this.inboxDir);
        this.mailOutputStream = new FileOutputStream(this.tempFile);
        this.mailFileWriter = new BufferedWriter(new FileWriter(this.tempFile));
        if (this.debugEnabled) {
            LOGGER.debug((Object)("Open temp file: " + this.tempFile.getAbsolutePath()));
        }
    }

    public void done() throws IOException {
        File outFile = File.createTempFile(this.filePrefix, this.fileSuffix, this.inboxDir);
        String outfileName = outFile.getAbsolutePath();
        this.tempFile.renameTo(outFile);
        LOGGER.info((Object)("Mail written to outfile " + outfileName));
    }

    public void destroy() throws IOException {
        this.tempFile.delete();
    }

    public void put(String line) throws IOException {
        this.mailFileWriter.write(line);
    }
}

