/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import de.lwsystems.mailarchive.input.SmtpHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.subethamail.smtp.server.SMTPServer;

public class SmtpServer {
    private static final Logger LOGGER = Logger.getLogger(SmtpServer.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private static final int LOGCONFIGWATCHPERIOD = 60000;
    static String outputDirectory = "/srv/benno/inbox";
    static Integer smtpPort = 2500;

    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("h", false, "print help");
        options.addOption("d", true, "Import directory (default: /srv/benno/inbox)");
        options.addOption("p", true, "Listen port (default: 2500");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("h")) {
            System.out.print(SmtpServer.getHelp());
            Runtime.getRuntime().exit(1);
        }
        if (cmd.hasOption("p")) {
            smtpPort = Integer.parseInt(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("d")) {
            outputDirectory = cmd.getOptionValue("d");
        }
        try {
            SmtpServer.configureLogging();
            LOGGER.info((Object)("Start Benno SMTP interface on port " + smtpPort + " writing to " + outputDirectory));
            System.out.println("Start Benno SMTP interface on port " + smtpPort + " writing to " + outputDirectory);
            SmtpHandler.inboxDir = outputDirectory;
            SmtpHandler smtpHandler = new SmtpHandler();
            SMTPServer smtpServer = new SMTPServer(smtpHandler);
            smtpServer.setPort(smtpPort);
            smtpServer.setDisableReceivedHeaders(true);
            smtpServer.start();
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Error accessing output directory " + outputDirectory + ": " + ex.getMessage()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error starting SMTP interface on " + smtpPort + ": " + ex.getMessage()));
        }
    }

    public static void configureLogging() throws FactoryConfigurationError {
        String logConfigName = "log4j.xml";
        if (System.getProperty("log4j.configuration") == null) {
            if (new File("/etc/benno/bennosmtp-log4j.xml").exists()) {
                logConfigName = "/etc/benno/bennosmtp-log4j.xml";
                DOMConfigurator.configureAndWatch((String)logConfigName, (long)60000L);
            }
        } else {
            logConfigName = System.getProperty("log4j.configuration");
            DOMConfigurator.configureAndWatch((String)logConfigName, (long)60000L);
        }
        if (System.getProperty("log4j.configuration") == null) {
            URL url = ClassLoader.getSystemResource("log4j.xml");
            DOMConfigurator.configure((URL)url);
        }
    }

    public static String getHelp() {
        String help = "Aufruf: benno-smtp [-h] -d <import directory> -p <smtp port>\n";
        return help;
    }
}

