/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import de.lwsystems.mailarchive.input.FileHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;

public class SmtpHandler
implements MessageHandlerFactory {
    private static final Logger LOGGER = Logger.getLogger(SmtpHandler.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    public static String CRLF = "\r\n";
    public static String rcpttoHeader = "X-REAL-RCPTTO: ";
    public static String mailFromHeader = "X-REAL-MAILFROM: ";
    public static String inboxDir;
    public static boolean addEnvelopeHeader;

    @Override
    public MessageHandler create(MessageContext ctx) {
        return new Handler(ctx);
    }

    class Handler
    implements MessageHandler {
        MessageContext ctx;
        private FileHandler mailFile;
        private int smtpStatus = 0;

        public Handler(MessageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void from(String sender) throws RejectException {
            if (SmtpHandler.this.debugEnabled) {
                LOGGER.debug((Object)"MAIL FROM COMMAND");
            }
            try {
                this.mailFile = new FileHandler(inboxDir);
                if (addEnvelopeHeader) {
                    if (SmtpHandler.this.debugEnabled) {
                        LOGGER.debug((Object)("Add sender header " + mailFromHeader + sender + CRLF));
                    }
                    this.mailFile.put(mailFromHeader + sender + CRLF);
                }
                ++this.smtpStatus;
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Cannot add sender header to output file", (Throwable)ex);
                throw new RejectException(451, "Cannot write output file");
            }
        }

        @Override
        public void recipient(String recipient) throws RejectException {
            try {
                if (addEnvelopeHeader) {
                    if (SmtpHandler.this.debugEnabled) {
                        LOGGER.debug((Object)("Add recipient header " + rcpttoHeader + recipient + CRLF));
                    }
                    this.mailFile.put(rcpttoHeader + recipient + CRLF);
                }
                ++this.smtpStatus;
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Cannot add from header recipient output file", (Throwable)ex);
                throw new RejectException(451, "Cannot write output file");
            }
        }

        @Override
        public void data(InputStream data) throws IOException {
            byte[] buffer = new byte[1024];
            int len = data.read(buffer);
            while (len != -1) {
                this.mailFile.mailOutputStream.write(buffer, 0, len);
                len = data.read(buffer);
            }
            ++this.smtpStatus;
        }

        @Override
        public void done() throws RejectException {
            LOGGER.debug((Object)("Close temp file: " + this.mailFile.tempFile.getAbsolutePath()));
            try {
                if (this.smtpStatus < 3) {
                    LOGGER.debug((Object)("SMTP session not complete: " + this.smtpStatus));
                    this.mailFile.destroy();
                } else {
                    this.mailFile.done();
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Cannot close output file", (Throwable)ex);
                throw new RejectException(451, "Cannot close output file");
            }
        }
    }
}

