/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.io.DotTerminatedInputStream;
import org.subethamail.smtp.io.DotUnstuffingInputStream;
import org.subethamail.smtp.io.ReceivedHeaderStream;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.Session;

public class DataCommand
extends BaseCommand {
    private static final int BUFFER_SIZE = 32768;

    public DataCommand() {
        super("DATA", "Following text is collected as the message.\nEnd data with <CR><LF>.<CR><LF>");
    }

    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        if (!sess.isMailTransactionInProgress()) {
            sess.sendResponse("503 5.5.1 Error: need MAIL command");
            return;
        }
        if (sess.getRecipientCount() == 0) {
            sess.sendResponse("503 Error: need RCPT command");
            return;
        }
        sess.sendResponse("354 End data with <CR><LF>.<CR><LF>");
        InputStream stream = sess.getRawInput();
        stream = new BufferedInputStream(stream, 32768);
        stream = new DotTerminatedInputStream(stream);
        stream = new DotUnstuffingInputStream(stream);
        if (!sess.getServer().getDisableReceivedHeaders()) {
            stream = new ReceivedHeaderStream(stream, sess.getHelo(), sess.getRemoteAddress().getAddress(), sess.getServer().getHostName(), sess.getServer().getSoftwareName(), sess.getSessionId(), sess.getSingleRecipient());
        }
        try {
            sess.getMessageHandler().data(stream);
            while (stream.read() != -1) {
            }
        }
        catch (DropConnectionException ex) {
            throw ex;
        }
        catch (RejectException ex) {
            sess.sendResponse(ex.getErrorResponse());
            return;
        }
        sess.sendResponse("250 Ok");
        sess.resetMailTransaction();
    }
}

