/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import org.subethamail.smtp.command.AuthCommand;
import org.subethamail.smtp.command.DataCommand;
import org.subethamail.smtp.command.EhloCommand;
import org.subethamail.smtp.command.ExpandCommand;
import org.subethamail.smtp.command.HelloCommand;
import org.subethamail.smtp.command.HelpCommand;
import org.subethamail.smtp.command.MailCommand;
import org.subethamail.smtp.command.NoopCommand;
import org.subethamail.smtp.command.QuitCommand;
import org.subethamail.smtp.command.ReceiptCommand;
import org.subethamail.smtp.command.ResetCommand;
import org.subethamail.smtp.command.StartTLSCommand;
import org.subethamail.smtp.command.VerifyCommand;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.RequireAuthCommandWrapper;
import org.subethamail.smtp.server.RequireTLSCommandWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CommandRegistry {
    AUTH(new AuthCommand(), true, false),
    DATA(new DataCommand(), true, true),
    EHLO(new EhloCommand(), false, false),
    HELO(new HelloCommand(), true, false),
    HELP(new HelpCommand(), true, true),
    MAIL(new MailCommand(), true, true),
    NOOP(new NoopCommand(), false, false),
    QUIT(new QuitCommand(), false, false),
    RCPT(new ReceiptCommand(), true, true),
    RSET(new ResetCommand(), true, false),
    STARTTLS(new StartTLSCommand(), false, false),
    VRFY(new VerifyCommand(), true, true),
    EXPN(new ExpandCommand(), true, true);

    private Command command;

    private CommandRegistry(Command cmd, boolean checkForStartedTLSWhenRequired, boolean checkForAuthIfRequired) {
        this.command = checkForStartedTLSWhenRequired ? new RequireTLSCommandWrapper(cmd) : cmd;
        if (checkForAuthIfRequired) {
            this.command = new RequireAuthCommandWrapper(this.command);
        }
    }

    public Command getCommand() {
        return this.command;
    }
}

