/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.Version;
import org.subethamail.smtp.server.CommandHandler;
import org.subethamail.smtp.server.ServerThread;
import org.subethamail.smtp.server.SessionIdFactory;
import org.subethamail.smtp.server.TimeBasedSessionIdFactory;

public class SMTPServer {
    private static final Logger log = LoggerFactory.getLogger(SMTPServer.class);
    private static final String UNKNOWN_HOSTNAME = "localhost";
    private InetAddress bindAddress = null;
    private int port = 25;
    private String hostName;
    private int backlog = 50;
    private String softwareName = "SubEthaSMTP " + Version.getSpecification();
    private MessageHandlerFactory messageHandlerFactory;
    private AuthenticationHandlerFactory authenticationHandlerFactory;
    private ExecutorService executorService;
    private final CommandHandler commandHandler;
    @GuardedBy(value="this")
    private ServerThread serverThread;
    @GuardedBy(value="this")
    private boolean started = false;
    private boolean enableTLS = false;
    private boolean hideTLS = false;
    private boolean requireTLS = false;
    private boolean requireAuth = false;
    private boolean disableReceivedHeaders = false;
    private int maxConnections = 1000;
    private int connectionTimeout = 60000;
    private int maxRecipients = 1000;
    private int maxMessageSize = 0;
    private SessionIdFactory sessionIdFactory = new TimeBasedSessionIdFactory();

    public SMTPServer(MessageHandlerFactory handlerFactory) {
        this(handlerFactory, null, null);
    }

    public SMTPServer(MessageHandlerFactory handlerFactory, AuthenticationHandlerFactory authHandlerFact) {
        this(handlerFactory, authHandlerFact, null);
    }

    public SMTPServer(MessageHandlerFactory msgHandlerFact, AuthenticationHandlerFactory authHandlerFact, ExecutorService executorService) {
        this.messageHandlerFactory = msgHandlerFact;
        this.authenticationHandlerFactory = authHandlerFact;
        this.executorService = executorService != null ? executorService : Executors.newCachedThreadPool();
        try {
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = UNKNOWN_HOSTNAME;
        }
        this.commandHandler = new CommandHandler();
    }

    public String getHostName() {
        if (this.hostName == null) {
            return UNKNOWN_HOSTNAME;
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSoftwareName() {
        return this.softwareName;
    }

    public void setSoftwareName(String value) {
        this.softwareName = value;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized boolean isRunning() {
        return this.serverThread != null;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public synchronized void start() {
        ServerSocket serverSocket;
        if (log.isInfoEnabled()) {
            log.info("SMTP server {} starting", (Object)this.getDisplayableLocalSocketAddress());
        }
        if (this.started) {
            throw new IllegalStateException("SMTPServer can only be started once. Restarting is not allowed even after a proper shutdown.");
        }
        try {
            serverSocket = this.createServerSocket();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.serverThread = new ServerThread(this, serverSocket);
        this.serverThread.start();
        this.started = true;
    }

    public synchronized void stop() {
        log.info("SMTP server {} stopping...", (Object)this.getDisplayableLocalSocketAddress());
        if (this.serverThread == null) {
            return;
        }
        this.serverThread.shutdown();
        this.serverThread = null;
        log.info("SMTP server {} stopped", (Object)this.getDisplayableLocalSocketAddress());
    }

    protected ServerSocket createServerSocket() throws IOException {
        InetSocketAddress isa = this.bindAddress == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress, this.port);
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(isa, this.backlog);
        if (this.port == 0) {
            this.port = serverSocket.getLocalPort();
        }
        return serverSocket;
    }

    public SSLSocket createSSLSocket(Socket socket) throws IOException {
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
        s.setUseClientMode(false);
        s.setEnabledCipherSuites(s.getSupportedCipherSuites());
        return s;
    }

    public String getDisplayableLocalSocketAddress() {
        return (this.bindAddress == null ? "*" : this.bindAddress) + ":" + this.port;
    }

    public MessageHandlerFactory getMessageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    public void setMessageHandlerFactory(MessageHandlerFactory fact) {
        this.messageHandlerFactory = fact;
    }

    public AuthenticationHandlerFactory getAuthenticationHandlerFactory() {
        return this.authenticationHandlerFactory;
    }

    public void setAuthenticationHandlerFactory(AuthenticationHandlerFactory fact) {
        this.authenticationHandlerFactory = fact;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        if (this.isRunning()) {
            throw new RuntimeException("Server is already running. It isn't possible to set the maxConnections. Please stop the server first.");
        }
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public void setMaxRecipients(int maxRecipients) {
        this.maxRecipients = maxRecipients;
    }

    public void setEnableTLS(boolean enableTLS) {
        this.enableTLS = enableTLS;
    }

    public boolean getEnableTLS() {
        return this.enableTLS;
    }

    @Deprecated
    public boolean getDisableTLS() {
        return !this.enableTLS;
    }

    @Deprecated
    public void setDisableTLS(boolean value) {
        this.enableTLS = !value;
    }

    public boolean getHideTLS() {
        return this.hideTLS;
    }

    public void setHideTLS(boolean value) {
        this.hideTLS = value;
    }

    public boolean getRequireTLS() {
        return this.requireTLS;
    }

    public void setRequireTLS(boolean requireTLS) {
        this.requireTLS = requireTLS;
    }

    public boolean getRequireAuth() {
        return this.requireAuth;
    }

    public void setRequireAuth(boolean requireAuth) {
        this.requireAuth = requireAuth;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public boolean getDisableReceivedHeaders() {
        return this.disableReceivedHeaders;
    }

    public void setDisableReceivedHeaders(boolean disableReceivedHeaders) {
        this.disableReceivedHeaders = disableReceivedHeaders;
    }

    public SessionIdFactory getSessionIdFactory() {
        return this.sessionIdFactory;
    }

    public void setSessionIdFactory(SessionIdFactory sessionIdFactory) {
        this.sessionIdFactory = sessionIdFactory;
    }
}

