/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.util.EmailUtils;

public class MailCommand
extends BaseCommand {
    private final Logger log = LoggerFactory.getLogger(MailCommand.class);

    public MailCommand() {
        super("MAIL", "Specifies the sender.", "FROM: <sender> [ <parameters> ]");
    }

    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        String ssize;
        if (sess.isMailTransactionInProgress()) {
            sess.sendResponse("503 5.5.1 Sender already specified.");
            return;
        }
        if (commandString.trim().equals("MAIL FROM:")) {
            sess.sendResponse("501 Syntax: MAIL FROM: <address>");
            return;
        }
        String args = this.getArgPredicate(commandString);
        if (!args.toUpperCase(Locale.ENGLISH).startsWith("FROM:")) {
            sess.sendResponse("501 Syntax: MAIL FROM: <address>  Error in parameters: \"" + this.getArgPredicate(commandString) + "\"");
            return;
        }
        String emailAddress = EmailUtils.extractEmailAddress(args, 5);
        if (!EmailUtils.isValidEmailAddress(emailAddress)) {
            this.log.warn("Accept mail with invalid address: " + emailAddress);
        }
        int size = 0;
        String largs = args.toLowerCase(Locale.ENGLISH);
        int sizec = largs.indexOf(" size=");
        if (sizec > -1 && (ssize = largs.substring(sizec + 6).trim()).length() > 0 && ssize.matches("[0-9]+")) {
            size = Integer.parseInt(ssize);
        }
        if (size > sess.getServer().getMaxMessageSize()) {
            sess.sendResponse("552 5.3.4 Message size exceeds fixed limit");
            return;
        }
        sess.setDeclaredMessageSize(size);
        sess.startMailTransaction();
        try {
            sess.getMessageHandler().from(emailAddress);
        }
        catch (DropConnectionException ex) {
            sess.resetMailTransaction();
            throw ex;
        }
        catch (RejectException ex) {
            sess.resetMailTransaction();
            sess.sendResponse(ex.getErrorResponse());
            return;
        }
        sess.sendResponse("250 Ok done.");
    }
}

