/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.input;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.subethamail.smtp.RejectException;

public class FileHandler {
    String fileSuffix = ".eml";
    String filePrefix = "smtp-";
    String inboxId = "";
    File inboxDir;
    File tempFile;
    FileOutputStream mailOutputStream;
    private static final Logger LOGGER = Logger.getLogger(FileHandler.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public FileHandler(String inboxPath) throws IOException {
        this.inboxDir = new File(inboxPath);
        this.tempFile = File.createTempFile(this.filePrefix, null, this.inboxDir);
        this.inboxId = this.tempFile.getName();
        this.mailOutputStream = new FileOutputStream(this.tempFile);
        if (this.debugEnabled) {
            LOGGER.debug((Object)("Open temp file: " + this.tempFile.getAbsolutePath()));
        }
    }

    public String done() throws IOException {
        this.mailOutputStream.flush();
        this.mailOutputStream.getFD().sync();
        this.mailOutputStream.close();
        String tempFilename = this.tempFile.getAbsolutePath();
        tempFilename = tempFilename.substring(0, tempFilename.lastIndexOf("."));
        String outputFilename = tempFilename + this.fileSuffix;
        try {
            File outFile = new File(outputFilename);
            outFile.createNewFile();
            this.tempFile.renameTo(outFile);
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Cannot write output file " + outputFilename), (Throwable)ex);
            throw new RejectException(451, "Cannot write output file");
        }
        return outputFilename;
    }

    public void destroy() throws IOException {
        this.tempFile.delete();
    }

    public void put(String line) throws IOException {
        byte[] byteLine = line.getBytes();
        this.mailOutputStream.write(byteLine, 0, byteLine.length);
    }
}

