/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.CommandException;
import org.subethamail.smtp.server.HelpMessage;
import org.subethamail.smtp.server.Session;

public class RequireAuthCommandWrapper
implements Command {
    private Command wrapped;

    public RequireAuthCommandWrapper(Command wrapped) {
        this.wrapped = wrapped;
    }

    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        if (!sess.getServer().getRequireAuth() || sess.isAuthenticated()) {
            this.wrapped.execute(commandString, sess);
        } else {
            sess.sendResponse("530 5.7.0  Authentication required");
        }
    }

    public HelpMessage getHelp() throws CommandException {
        return this.wrapped.getHelp();
    }

    public String getName() {
        return this.wrapped.getName();
    }
}

