#!/bin/sh
# postinst script for benno-archive
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    if [ -x "/etc/init.d/benno-smtp" ]; then
        update-rc.d benno-smtp defaults >/dev/null
        set +e
        /etc/init.d/benno-smtp start
    fi
    ;;
    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac


perl -p -i -e 's/^BENNOCOREDIR=\/opt\/benno$/BENNOCOREDIR=\/opt\/benno-smtp/' /etc/init.d/benno-smtp

exit 0
