/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Mail;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class Mail {
    MailDocument document;

    public Mail(String bennoId, String scid, IBox iBox) {
        MailDocumentId mailDocumentId = new MailDocumentId(bennoId, scid);
        this.document = iBox.getDocument(mailDocumentId);
    }

    public Mail(String bennoId, IBox iBox) {
        MailDocumentId mailDocumentId = new MailDocumentId(bennoId);
        this.document = iBox.getDocument(mailDocumentId);
    }

    public BufferedOutputStream getMailBufferedOutputStream() {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(System.out);
        try {
            IOUtils.copy((InputStream)this.document.getMailStream(), (OutputStream)bufferedOutputStream);
            bufferedOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bufferedOutputStream;
    }

    public ByteArrayOutputStream getMailByteArrayOutputStream() {
        try {
            ByteArrayOutputStream mailOutput = new ByteArrayOutputStream();
            mailOutput.write(this.document.getMailData());
            return mailOutput;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

