/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3.clientCreator.bucketStats;

import de.lwsystems.mailarchive.storage.s3.clientCreator.bucketStats.BucketStats;
import de.lwsystems.mailarchive.storage.s3.clientCreator.bucketStats.S3BucketStatsCalculator;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Item;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class MinioBucketStatsCalculator
implements S3BucketStatsCalculator {
    private MinioClient minioClient;

    public MinioBucketStatsCalculator(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    @Override
    public BucketStats getBucketStats(String bucketName, String prefix) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        int totalObjects = 0;
        long totalSize = 0L;
        ListObjectsArgs listArgs = this.createListObjectsArgs(bucketName, prefix);
        Iterable objects = this.minioClient.listObjects(listArgs);
        for (Result result : objects) {
            totalSize = this.updateTotalSize((Result<Item>)result);
            totalObjects = this.incrementObjectCount(totalObjects);
        }
        return new BucketStats(bucketName, prefix, totalSize, totalObjects);
    }

    @Override
    public BucketStats getBucketStats(String bucketName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        int totalObjects = 0;
        long totalSize = 0L;
        ListObjectsArgs listArgs = this.createListObjectsArgs(bucketName);
        Iterable objects = this.minioClient.listObjects(listArgs);
        for (Result result : objects) {
            totalSize = this.updateTotalSize((Result<Item>)result);
            totalObjects = this.incrementObjectCount(totalObjects);
        }
        return new BucketStats(bucketName, totalSize, totalObjects);
    }

    private ListObjectsArgs createListObjectsArgs(String bucketName, String prefix) {
        return (ListObjectsArgs)((ListObjectsArgs.Builder)new ListObjectsArgs.Builder().bucket(bucketName)).prefix(prefix).maxKeys(1000).build();
    }

    private ListObjectsArgs createListObjectsArgs(String bucketName) {
        return (ListObjectsArgs)((ListObjectsArgs.Builder)new ListObjectsArgs.Builder().bucket(bucketName)).maxKeys(1000).build();
    }

    private long updateTotalSize(Result<Item> result) throws ErrorResponseException, IOException, InvalidKeyException, NoSuchAlgorithmException, XmlParserException, InternalException, ServerException, InsufficientDataException, InvalidResponseException {
        return ((Item)result.get()).size();
    }

    private int incrementObjectCount(int totalObjects) {
        return totalObjects + 1;
    }
}

