/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Benno.Box;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.s3tool.Benno.Box.BennoBoxes;
import java.util.Map;
import java.util.stream.Collectors;

public class S3Boxes
extends BennoBoxes {
    public S3Boxes(Benno benno) {
        super(benno);
    }

    public S3Boxes(Benno benno, String container) throws ArchiveNotFoundException, ContainerNotFoundException {
        super(benno, container);
    }

    @Override
    public void setContainerBoxMap(IContainer container) {
        if (this.isS3Box(container)) {
            super.getContainerBoxMap().putAll(Map.of(container, container.getBoxGenerator().getState().getBoxes().keySet().stream().map(boxState -> {
                try {
                    return container.getBox(boxState);
                }
                catch (ArchiveException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList())));
        }
    }

    public boolean isS3Box(IContainer container) {
        return container.getBoxGenerator().getBoxGeneratorConfig().getBoxConfigTemplate().getBoxStorageConfig().getDriver().equalsIgnoreCase("s3");
    }
}

