/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3.clientCreator.bucketStats;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.lwsystems.mailarchive.storage.s3.clientCreator.bucketStats.BucketStats;
import de.lwsystems.mailarchive.storage.s3.clientCreator.bucketStats.S3BucketStatsCalculator;
import de.lwsystems.mailarchive.utils.ByteConverter;

public class AwsBucketStatsCalculator
implements S3BucketStatsCalculator {
    private AmazonS3 awsClient;

    public AwsBucketStatsCalculator(AmazonS3 awsClient) {
        this.awsClient = awsClient;
    }

    @Override
    public BucketStats getBucketStats(String bucketName, String prefix) {
        ListObjectsV2Result listObjectsResult;
        int totalObjects = 0;
        double totalSize = 0.0;
        ListObjectsV2Request listObjectsRequest = this.createListObjectsRequest(bucketName, prefix);
        do {
            listObjectsResult = this.listObjects(listObjectsRequest);
            totalObjects = this.updateObjectCount(listObjectsResult, totalObjects);
            totalSize = this.updateTotalSize(listObjectsResult, totalSize);
            listObjectsRequest.setContinuationToken(listObjectsResult.getNextContinuationToken());
        } while (listObjectsResult.isTruncated());
        return new BucketStats(bucketName, prefix, totalSize, totalObjects);
    }

    @Override
    public BucketStats getBucketStats(String bucketName) {
        ListObjectsV2Result listObjectsResult;
        int totalObjects = 0;
        double totalSize = 0.0;
        ListObjectsV2Request listObjectsRequest = this.createListObjectsRequest(bucketName);
        do {
            listObjectsResult = this.listObjects(listObjectsRequest);
            totalObjects = this.updateObjectCount(listObjectsResult, totalObjects);
            totalSize = this.updateTotalSize(listObjectsResult, totalSize);
            listObjectsRequest.setContinuationToken(listObjectsResult.getNextContinuationToken());
        } while (listObjectsResult.isTruncated());
        return new BucketStats(bucketName, totalSize, totalObjects);
    }

    private ListObjectsV2Request createListObjectsRequest(String bucketName, String prefix) {
        return new ListObjectsV2Request().withBucketName(bucketName).withPrefix(prefix);
    }

    private ListObjectsV2Request createListObjectsRequest(String bucketName) {
        return new ListObjectsV2Request().withBucketName(bucketName);
    }

    private ListObjectsV2Result listObjects(ListObjectsV2Request listObjectsRequest) {
        return this.awsClient.listObjectsV2(listObjectsRequest);
    }

    private int updateObjectCount(ListObjectsV2Result listObjectsResult, int totalObjects) {
        return totalObjects + listObjectsResult.getObjectSummaries().size();
    }

    private double updateTotalSize(ListObjectsV2Result listObjectsResult, double totalSize) {
        for (S3ObjectSummary objectSummary : listObjectsResult.getObjectSummaries()) {
            totalSize += ByteConverter.bytesToMegabytes((double)objectSummary.getSize());
        }
        return totalSize;
    }
}

