/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Output;

import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.stream.Stream;

public final class Output {
    private Output() {
        throw new IllegalStateException("Utility class");
    }

    public static void printEmptyLine() {
        System.out.println(" ");
    }

    public static void printHeader() {
        Output.printEmptyLine();
        System.out.println("S3-Tool for Benno Mailarchiv");
        Output.printLine();
    }

    public static void printContainerHeadline(String containerName) {
        System.out.println("######### " + containerName + " #########");
    }

    public static void printBennoIdHeadline(String bennoId) {
        System.out.println("ID : " + bennoId);
    }

    public static void printError(String message) {
        System.out.println("ERROR: " + message);
    }

    public static void printSuccess(String message) {
        System.out.println("SUCCESS: " + message);
    }

    public static void printMessage(String message) {
        System.out.println(message);
        Output.printEmptyLine();
    }

    public static void printMailHeadline(String containerName, String bennoId) {
        Output.printContainerHeadline(containerName);
        Output.printBennoIdHeadline(bennoId);
        Output.printEmptyLine();
    }

    public static void printLine() {
        System.out.println("--------------------------------------------------");
    }

    public static void printUploadedMail(String sourcePath, String bucketName) {
        System.out.println("Upload " + sourcePath + " to bucket " + bucketName + " was successful");
        Output.printEmptyLine();
    }

    public static void printMap(Map<String, Object> map) {
        map.forEach((k, v) -> System.out.println(k + " : " + v));
        Output.printEmptyLine();
    }

    public static void printStream(Stream<?> stream) {
        stream.forEach(System.out::println);
    }

    public static void printReader(BufferedOutputStream reader) throws IOException {
        PrintStream printStream = new PrintStream(reader);
        printStream.println();
    }

    public static void printReader(ByteArrayOutputStream reader) {
        System.out.print(reader);
    }

    public static void printContainerBucketConfiguration(S3BoxStorageConfig s3BoxStorageConfig) {
        System.out.println("Bucket-Identifier: " + s3BoxStorageConfig.getIdentifier());
        System.out.println("Bucket: " + s3BoxStorageConfig.getBucket());
        System.out.println("AuthKeyId: " + s3BoxStorageConfig.getAuthentication().getAuthKeyId());
        System.out.println("AuthKey: " + s3BoxStorageConfig.getAuthentication().getAuthKey());
        System.out.println("Endpoint: " + s3BoxStorageConfig.getEndpoint());
        System.out.println("Region: " + s3BoxStorageConfig.getRegion());
        Output.printEmptyLine();
    }
}

