/*
 * Decompiled with CFR 0.152.
 */
package io.minio.policy;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.minio.policy.ConditionKeyMap;
import io.minio.policy.ConditionMap;
import io.minio.policy.Constants;
import io.minio.policy.Principal;
import io.minio.policy.Resources;
import java.util.HashSet;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class Statement {
    @JsonProperty(value="Action")
    private Set<String> actions;
    @JsonProperty(value="Condition")
    private ConditionMap conditions;
    @JsonProperty(value="Effect")
    private String effect;
    @JsonProperty(value="Principal")
    private Principal principal;
    @JsonProperty(value="Resource")
    private Resources resources;
    @JsonProperty(value="Sid")
    private String sid;

    public Set<String> actions() {
        return this.actions;
    }

    public void setActions(Set<String> actions) {
        this.actions = actions;
    }

    public ConditionMap conditions() {
        return this.conditions;
    }

    public void setConditions(ConditionMap conditions) {
        this.conditions = conditions;
    }

    public String effect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public Principal principal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Resources resources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public String sid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public boolean isValid(String bucketName) {
        HashSet<String> intersection = new HashSet<String>(this.actions);
        intersection.retainAll(Constants.VALID_ACTIONS);
        if (intersection.isEmpty()) {
            return false;
        }
        if (!this.effect.equals("Allow")) {
            return false;
        }
        Set<String> aws = this.principal.aws();
        if (aws == null || !aws.contains("*")) {
            return false;
        }
        String bucketResource = "arn:aws:s3:::" + bucketName;
        if (this.resources.contains(bucketResource)) {
            return true;
        }
        return !this.resources.startsWith(bucketResource + "/").isEmpty();
    }

    public void removeObjectActions(String objectResource) {
        if (this.conditions != null) {
            return;
        }
        if (this.resources.size() > 1) {
            this.resources.remove(objectResource);
        } else {
            this.actions.removeAll(Constants.READ_WRITE_OBJECT_ACTIONS);
        }
    }

    private void removeReadOnlyBucketActions(String prefix) {
        if (!this.actions.containsAll(Constants.READ_ONLY_BUCKET_ACTIONS)) {
            return;
        }
        this.actions.removeAll(Constants.READ_ONLY_BUCKET_ACTIONS);
        if (this.conditions == null) {
            return;
        }
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        ConditionKeyMap stringEqualsValue = (ConditionKeyMap)this.conditions.get("StringEquals");
        if (stringEqualsValue == null) {
            return;
        }
        Set values = (Set)stringEqualsValue.get("s3:prefix");
        if (values != null) {
            values.remove(prefix);
        }
        if (values == null || values.isEmpty()) {
            stringEqualsValue.remove("s3:prefix");
        }
        if (stringEqualsValue.isEmpty()) {
            this.conditions.remove("StringEquals");
        }
        if (this.conditions.isEmpty()) {
            this.conditions = null;
        }
    }

    private void removeWriteOnlyBucketActions() {
        if (this.conditions == null) {
            this.actions.removeAll(Constants.WRITE_ONLY_BUCKET_ACTIONS);
        }
    }

    public void removeBucketActions(String prefix, String bucketResource, boolean readOnlyInUse, boolean writeOnlyInUse) {
        if (this.resources.size() > 1) {
            this.resources.remove(bucketResource);
            return;
        }
        if (!readOnlyInUse) {
            this.removeReadOnlyBucketActions(prefix);
        }
        if (!writeOnlyInUse) {
            this.removeWriteOnlyBucketActions();
        }
    }

    @JsonIgnore
    public boolean[] getBucketPolicy(String prefix) {
        boolean commonFound = false;
        boolean readOnly = false;
        boolean writeOnly = false;
        Set<String> aws = this.principal.aws();
        if (!this.effect.equals("Allow") || aws == null || !aws.contains("*")) {
            return new boolean[]{commonFound, readOnly, writeOnly};
        }
        if (this.actions.containsAll(Constants.COMMON_BUCKET_ACTIONS) && this.conditions == null) {
            commonFound = true;
        }
        if (this.actions.containsAll(Constants.WRITE_ONLY_BUCKET_ACTIONS) && this.conditions == null) {
            writeOnly = true;
        }
        if (this.actions.containsAll(Constants.READ_ONLY_BUCKET_ACTIONS)) {
            if (prefix != null && !prefix.isEmpty() && this.conditions != null) {
                ConditionKeyMap stringEqualsValue = (ConditionKeyMap)this.conditions.get("StringEquals");
                if (stringEqualsValue != null) {
                    Set s3PrefixValues = (Set)stringEqualsValue.get("s3:prefix");
                    if (s3PrefixValues != null && s3PrefixValues.contains(prefix)) {
                        readOnly = true;
                    }
                } else {
                    Set s3PrefixValues;
                    ConditionKeyMap stringNotEqualsValue = (ConditionKeyMap)this.conditions.get("StringNotEquals");
                    if (stringNotEqualsValue != null && (s3PrefixValues = (Set)stringNotEqualsValue.get("s3:prefix")) != null && !s3PrefixValues.contains(prefix)) {
                        readOnly = true;
                    }
                }
            } else if ((prefix == null || prefix.isEmpty()) && this.conditions == null) {
                readOnly = true;
            } else if (prefix != null && !prefix.isEmpty() && this.conditions == null) {
                readOnly = true;
            }
        }
        return new boolean[]{commonFound, readOnly, writeOnly};
    }

    @JsonIgnore
    public boolean[] getObjectPolicy() {
        boolean readOnly = false;
        boolean writeOnly = false;
        Set<String> aws = null;
        if (this.principal != null) {
            aws = this.principal.aws();
        }
        if (this.effect.equals("Allow") && aws != null && aws.contains("*") && this.conditions == null) {
            if (this.actions.containsAll(Constants.READ_ONLY_OBJECT_ACTIONS)) {
                readOnly = true;
            }
            if (this.actions.containsAll(Constants.WRITE_ONLY_OBJECT_ACTIONS)) {
                writeOnly = true;
            }
        }
        return new boolean[]{readOnly, writeOnly};
    }
}

