package Benno::Boxstate;
use Benno::Box;
use strict;


sub new
{
    my $class = shift;
    my ($filename)  = @_;
    my $self = {
        filename => $filename,
        boxes => {},
    };
    bless $self, $class;
    $self->_init();

    return $self;
}


sub addBox
{
    my ($self,$Box) = @_;

    my $boxid = $Box->id;
    $self->{boxes}->{$boxid} = $Box;
}


sub getBox
{
    my ($self,$boxid) = @_;

    return $self->{boxes}->{$boxid};
}


sub getBoxes
{
    my ($self) = @_;

    my @retlist;
    foreach my $boxid (keys %{$self->{boxes}}) {
        push @retlist, $self->{boxes}->{$boxid};
    }

    return @retlist;
}



### EOP ###
1;

