package Benno::Boxstate::S3;
use parent 'Benno::Boxstate';
use XML::LibXML;
use Benno::Box;
use strict;


sub _init
{
    my ($self) = @_;

    my $dom = XML::LibXML->load_xml(location => $self->{filename});

    # load boxes
    my $boxes;
    foreach my $node ($dom->findnodes('/boxstate/box')) {
        my $Box = new Benno::Box($node->getAttribute('identifier'));
        my $endpoint = $node->findvalue('box/config/storage/endpoint');
        $endpoint =~ s!^https://!!;
        $endpoint =~ s!/.*$!!;
        $Box->setConfig('endpoint',$endpoint);
        $Box->setConfig('authKeyId',$node->findvalue('box/config/storage/authentication/authKeyId'));
        $Box->setConfig('authKey',$node->findvalue('box/config/storage/authentication/authKey'));
        $Box->setConfig('boxName',$node->findvalue('box/config/storage/boxName'));
        $Box->setConfig('bennoPath',$node->findvalue('box/config/storage/bennoPath'));
        $Box->setConfig('bucket',$node->findvalue('box/config/storage/bucket'));
        $self->addBox($Box);
    }
}


### EOP ###
1;
