/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3;

import com.amazonaws.SdkClientException;
import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.journal.IJournal;
import de.lwsystems.mailarchive.archive.journal.JournalEntry;
import de.lwsystems.mailarchive.archive.storage.IS3BennoStorage;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.mailfile.FSMailFile;
import de.lwsystems.mailarchive.mailfile.IMailFile;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import de.lwsystems.mailarchive.storage.s3.S3Upload;
import de.lwsystems.mailarchive.storage.s3.clientCreator.AwsS3Client;
import de.lwsystems.mailarchive.storage.s3.clientCreator.MinioS3Client;
import de.lwsystems.mailarchive.storage.s3.clientCreator.S3ClientCreator;
import de.lwsystems.mailarchive.storage.s3.journal.S3FailJournalEntry;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.MinioException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class S3BoxStorage
implements IS3BennoStorage {
    private static final Logger LOGGER = Logger.getLogger(S3BoxStorage.class);
    private final S3BoxStorageConfig s3BoxStorageConfig;
    private S3ClientCreator client;
    private S3Upload s3Upload;

    S3BoxStorage(S3BoxStorageConfig s3BoxStorageConfig) {
        this.s3BoxStorageConfig = s3BoxStorageConfig;
        this.s3Upload = new S3Upload();
    }

    public boolean exists() {
        return this.doesBucketExist(this.getS3Client());
    }

    public void ensureReadyFor(MailDocument document, String identifier) throws FailedArchivingException {
        this.createBucket();
    }

    public OutputStream getOutStream(MailDocumentId documentId, IBox.CompressionType compType) throws IOException, FailedArchivingException {
        int duplicateId = 0;
        String objectName = this.getObjectName(documentId, compType);
        while (this.getS3Client().doesObjectExist(this.getBucketName(), objectName)) {
            objectName = documentId.getHashHex() + ConversionUtil.fromIntToHex((int)(++duplicateId));
        }
        PipedInputStream inputStream = new PipedInputStream();
        S3ClientCreator s3Client = this.getS3Client();
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        FSMailFile s3LocalFile = new FSMailFile(documentId);
        new Thread(() -> this.lambda$getOutStream$0(s3Client, documentId, compType, inputStream, (IMailFile)s3LocalFile)).start();
        return outputStream;
    }

    public InputStream getInStream(MailDocumentId id, IBox.CompressionType compType) {
        InputStream s3ClientObject;
        S3ClientCreator s3Client = this.getS3Client();
        String bucketName = this.getBucketName();
        String objectName = this.getObjectName(id, compType);
        try {
            s3ClientObject = s3Client.getObject(bucketName, objectName);
        }
        catch (Exception ex) {
            s3ClientObject = s3Client.getObject(bucketName, this.getObjectNameFallback(id));
        }
        return s3ClientObject;
    }

    public boolean hasDocument(MailDocumentId documentId, IBox.CompressionType compType) {
        String objectName = this.getObjectName(documentId, compType);
        String bucketName = this.getBucketName();
        boolean hasDocument = this.getS3Client().doesObjectExist(bucketName, objectName);
        if (hasDocument) {
            LOGGER.debug((Object)(objectName + " in " + bucketName + " was not loaded into S3 because this mail already exists in bucket."));
        }
        return hasDocument;
    }

    private String getObjectName(MailDocumentId documentId, IBox.CompressionType compType) {
        if (!documentId.getScid().equals("")) {
            return this.s3BoxStorageConfig.getBennoPath() + "/" + documentId.getScid() + "/" + documentId.getInternalBoxIndentifier() + ":" + documentId.getHashHex() + documentId.getDuplicateIdHex() + CompressionUtil.getCompressionSuffix((IBox.CompressionType)compType);
        }
        return this.s3BoxStorageConfig.getBennoPath() + "/" + documentId.getInternalBoxIndentifier() + ":" + documentId.getHashHex() + documentId.getDuplicateIdHex() + CompressionUtil.getCompressionSuffix((IBox.CompressionType)compType);
    }

    private String getObjectNameFallback(MailDocumentId documentId) {
        return documentId.getHashHex() + documentId.getDuplicateIdHex();
    }

    private S3ClientCreator getS3Client() {
        if (this.client != null) {
            return this.client;
        }
        S3ClientCreator clientCreator = this.s3BoxStorageConfig.isMinioBackend() != false ? new MinioS3Client(this.s3BoxStorageConfig) : new AwsS3Client(this.s3BoxStorageConfig);
        this.client = clientCreator;
        return clientCreator;
    }

    private String getBucketName() {
        return this.s3BoxStorageConfig.getBucket();
    }

    private boolean bucketExists() {
        S3ClientCreator client = this.getS3Client();
        return this.doesBucketExist(client);
    }

    void deleteObjectsInBucket() throws XmlPullParserException {
        this.getS3Client().deleteObjectsInBucket(this.getBucketName());
    }

    void createBucket() {
        if (!this.bucketExists()) {
            try {
                this.client.createBucket(this.getBucketName());
            }
            catch (SdkClientException | ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException ex) {
                throw new RuntimeArchiveException("Bucket \"" + this.getBucketName() + "\" can't be created.", ex);
            }
            LOGGER.info((Object)("Created bucket " + this.getBucketName()));
        }
    }

    void deleteBucket() {
        if (this.bucketExists()) {
            try {
                this.deleteObjectsInBucket();
                this.client.deleteBucket(this.getBucketName());
            }
            catch (SdkClientException | ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException ex) {
                throw new RuntimeArchiveException("Bucket \"" + this.getBucketName() + "\" can't be deleted.", ex);
            }
        }
        LOGGER.info((Object)("Deleted bucket " + this.getBucketName()));
    }

    private boolean doesBucketExist(S3ClientCreator client) {
        try {
            return client.doesBucketExists(this.getBucketName());
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void startJournalThread(IJournal journal, MailDocument document) {
        new Thread(() -> {
            S3Upload s3Upload = this.s3Upload;
            synchronized (s3Upload) {
                if (!this.s3Upload.isFileUploaded().booleanValue() && this.s3Upload.getFileUploadedException() != null) {
                    journal.addEntry((JournalEntry)new S3FailJournalEntry(document, this.s3Upload.getFileUploadedException()));
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$getOutStream$0(S3ClientCreator s3Client, MailDocumentId documentId, IBox.CompressionType compType, PipedInputStream inputStream, IMailFile s3LocalFile) {
        S3Upload s3Upload = this.s3Upload;
        synchronized (s3Upload) {
            try {
                s3Client.putObject(this.getBucketName(), this.getObjectName(documentId, compType), inputStream);
                s3LocalFile.deleteMailFile(this.s3BoxStorageConfig.getBennoPath());
                LOGGER.info((Object)("Mail " + documentId + " was added to the S3 storage " + this.getBucketName()));
                this.s3Upload.setFileUploaded(true);
            }
            catch (SdkClientException | ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException ex) {
                LOGGER.error((Object)("Mail " + documentId + " can't upload to S3 storage " + this.getBucketName()), ex);
                this.s3Upload.setFileUploadedException(ex);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Unknown exception " + this.getBucketName()), (Throwable)ex);
            }
            this.s3Upload.notifyAll();
        }
    }
}

