/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3.clientCreator;

import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import de.lwsystems.mailarchive.storage.s3.clientCreator.S3ClientCreator;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class MinioS3Client
implements S3ClientCreator {
    private MinioClient minioClient;

    public MinioS3Client(S3BoxStorageConfig s3BoxStorageConfig) {
        this.createS3Client(s3BoxStorageConfig);
    }

    @Override
    public void createS3Client(S3BoxStorageConfig s3BoxStorageConfig) {
        this.minioClient = MinioClient.builder().endpoint(s3BoxStorageConfig.getEndpoint()).credentials(s3BoxStorageConfig.getAuthentication().getAuthKeyId(), s3BoxStorageConfig.getAuthentication().getAuthKey()).region(s3BoxStorageConfig.getRegion()).build();
    }

    @Override
    public InputStream getObject(String bucketName, String objectName) {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeArchiveException("Object \"" + bucketName + "\" cannot be loaded.", ex);
        }
    }

    @Override
    public void putObject(String bucketName, String objectName, InputStream inputStream) throws IOException, ServerException, InsufficientDataException, ErrorResponseException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, -1L, 0xA00000L).build());
    }

    private Iterable<Result<Item>> getObjects(String bucketName) {
        return this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
    }

    @Override
    public void deleteObjectsInBucket(String bucketName) {
        Iterable<Result<Item>> results = this.getObjects(bucketName);
        MinioClient finalMinioClient = this.minioClient;
        results.forEach(object -> {
            try {
                finalMinioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).build());
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException ex) {
                throw new RuntimeArchiveException("Object \"" + bucketName + "\" cannot be deleted.", ex);
            }
        });
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) {
        try {
            this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeArchiveException("Object \"" + bucketName + "\" cannot be loaded.", ex);
        }
        catch (ErrorResponseException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void createBucket(String bucketName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
    }

    @Override
    public boolean doesBucketExists(String bucketName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    @Override
    public void deleteBucket(String bucketName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }
}

