/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.storage.s3.clientCreator;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import de.lwsystems.mailarchive.storage.s3.clientCreator.S3ClientCreator;
import java.io.InputStream;
import java.util.Iterator;

public class AwsS3Client
implements S3ClientCreator {
    private AmazonS3 awsClient;

    public AwsS3Client(S3BoxStorageConfig s3BoxStorageConfig) {
        this.createS3Client(s3BoxStorageConfig);
    }

    @Override
    public void createS3Client(S3BoxStorageConfig s3BoxStorageConfig) {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true));
        if (s3BoxStorageConfig.getEndpoint() != null) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(s3BoxStorageConfig.getEndpoint(), s3BoxStorageConfig.getRegion());
            builder.withEndpointConfiguration(endpoint);
        } else if (s3BoxStorageConfig.getRegion() != null) {
            builder.withRegion(Regions.fromName((String)s3BoxStorageConfig.getRegion()));
        }
        S3BoxStorageConfig.S3Authentication authentication = s3BoxStorageConfig.getAuthentication();
        if (authentication != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(authentication.getAuthKeyId(), authentication.getAuthKey());
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials));
        } else {
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()));
        }
        this.awsClient = (AmazonS3)builder.build();
    }

    @Override
    public InputStream getObject(String bucketName, String objectName) throws SdkClientException {
        return this.awsClient.getObject(bucketName, objectName).getObjectContent();
    }

    @Override
    public void putObject(String bucketName, String objectName, InputStream inputStream) throws SdkClientException {
        ObjectMetadata metadata = new ObjectMetadata();
        this.awsClient.putObject(bucketName, objectName, inputStream, metadata);
    }

    private ObjectListing getObjects(String bucketName) throws SdkClientException {
        return this.awsClient.listObjects(bucketName);
    }

    @Override
    public void deleteObjectsInBucket(String bucketName) throws SdkClientException {
        ObjectListing objectListing = this.getObjects(bucketName);
        while (true) {
            Iterator objIter = objectListing.getObjectSummaries().iterator();
            while (objIter.hasNext()) {
                this.awsClient.deleteObject(bucketName, ((S3ObjectSummary)objIter.next()).getKey());
            }
            if (!objectListing.isTruncated()) break;
            objectListing = this.awsClient.listNextBatchOfObjects(objectListing);
        }
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) throws SdkClientException {
        return this.awsClient.doesObjectExist(bucketName, objectName);
    }

    @Override
    public void createBucket(String bucketName) throws SdkClientException {
        this.awsClient.createBucket(bucketName);
    }

    @Override
    public boolean doesBucketExists(String bucketName) throws SdkClientException {
        return this.awsClient.doesBucketExistV2(bucketName);
    }

    @Override
    public void deleteBucket(String bucketName) throws SdkClientException {
        this.awsClient.deleteBucket(bucketName);
    }
}

