/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.route;

import akka.http.javadsl.model.HttpHeader;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString$;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.S3ChunkedProtocolStage;
import io.findify.s3mock.error.InternalErrorException;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.route.PutObject$;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001.\u0011\u0011\u0002U;u\u001f\nTWm\u0019;\u000b\u0005\r!\u0011!\u0002:pkR,'BA\u0003\u0007\u0003\u0019\u00198'\\8dW*\u0011q\u0001C\u0001\bM&tG-\u001b4z\u0015\u0005I\u0011AA5p\u0007\u0001\u0019R\u0001\u0001\u0007\u00139}\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u001b\u001b\u0005!\"BA\u000b\u0017\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t9\u0002$\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0012aA2p[&\u00111\u0004\u0006\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0005\u0002\u000e;%\u0011aD\u0004\u0002\b!J|G-^2u!\ti\u0001%\u0003\u0002\"\u001d\ta1+\u001a:jC2L'0\u00192mK\"A1\u0005\u0001BC\u0002\u0013\rA%\u0001\u0005qe>4\u0018\u000eZ3s+\u0005)\u0003C\u0001\u0014)\u001b\u00059#BA\u0012\u0005\u0013\tIsE\u0001\u0005Qe>4\u0018\u000eZ3s\u0011!Y\u0003A!A!\u0002\u0013)\u0013!\u00039s_ZLG-\u001a:!\u0011!i\u0003A!b\u0001\n\u0007q\u0013aA7biV\tq\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u000511\u000f\u001e:fC6T\u0011\u0001N\u0001\u0005C.\\\u0017-\u0003\u00027c\taQ*\u0019;fe&\fG.\u001b>fe\"A\u0001\b\u0001B\u0001B\u0003%q&\u0001\u0003nCR\u0004\u0003\"\u0002\u001e\u0001\t\u0003Y\u0014A\u0002\u001fj]&$h\bF\u0001=)\rit\b\u0011\t\u0003}\u0001i\u0011A\u0001\u0005\u0006Ge\u0002\u001d!\n\u0005\u0006[e\u0002\u001da\f\u0005\u0006\u0007\u0001!\tA\u0011\u000b\u0004\u0007Fs\u0006C\u0001#O\u001d\t)E*D\u0001G\u0015\t9\u0005*\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0013*\u000b\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003\u0017N\nA\u0001\u001b;ua&\u0011QJR\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005KA\u0003S_V$XM\u0003\u0002N\r\")!+\u0011a\u0001'\u00061!-^2lKR\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,\u000f\u001b\u00059&B\u0001-\u000b\u0003\u0019a$o\\8u}%\u0011!LD\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[\u001d!)q,\u0011a\u0001'\u0006!\u0001/\u0019;i\u0011\u0015\t\u0007\u0001\"\u0001c\u00039\u0019w.\u001c9mKR,7+[4oK\u0012$2a\u0019:t!\u0011iAMZ5\n\u0005\u0015t!!\u0003$v]\u000e$\u0018n\u001c82!\t)u-\u0003\u0002i\r\nq!+Z9vKN$8i\u001c8uKb$\bc\u00016n_6\t1N\u0003\u0002m\u001d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00059\\'A\u0002$viV\u0014X\r\u0005\u0002Fa&\u0011\u0011O\u0012\u0002\f%>,H/\u001a*fgVdG\u000fC\u0003SA\u0002\u00071\u000bC\u0003`A\u0002\u00071\u000bC\u0003v\u0001\u0011\u0005a/A\u0007d_6\u0004H.\u001a;f!2\f\u0017N\u001c\u000b\u0004G^D\b\"\u0002*u\u0001\u0004\u0019\u0006\"B0u\u0001\u0004\u0019\u0006\"\u0002>\u0001\t\u0013Y\u0018A\u00069paVd\u0017\r^3PE*,7\r^'fi\u0006$\u0017\r^1\u0015\u000bq\f\t\"a\b\u0011\u0007u\fi!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003\u0007\t)!\u0001\u0002tg)!\u0011qAA\u0005\u0003!\u0019XM\u001d<jG\u0016\u001c(bAA\u00061\u0005I\u0011-\\1{_:\fwo]\u0005\u0004\u0003\u001fq(AD(cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0005\b\u0003'I\b\u0019AA\u000b\u0003\u001d\u0011X-];fgR\u0004B!a\u0006\u0002\u001c5\u0011\u0011\u0011\u0004\u0006\u0003\u007f\"KA!!\b\u0002\u001a\tY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u001d\t\t#\u001fa\u0001\u0003G\tQAY=uKN\u0004R!DA\u0013\u0003SI1!a\n\u000f\u0005\u0015\t%O]1z!\ri\u00111F\u0005\u0004\u0003[q!\u0001\u0002\"zi\u0016D\u0011\"!\r\u0001\u0003\u0003%\t!a\r\u0002\t\r|\u0007/\u001f\u000b\u0003\u0003k!R!PA\u001c\u0003sAaaIA\u0018\u0001\b)\u0003BB\u0017\u00020\u0001\u000fq\u0006C\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005!A.\u00198h\u0015\t\tY%\u0001\u0003kCZ\f\u0017b\u0001/\u0002F!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111K\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00022!DA,\u0013\r\tIF\u0004\u0002\u0004\u0013:$\b\"CA/\u0001\u0005\u0005I\u0011AA0\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0019\u0002hA\u0019Q\"a\u0019\n\u0007\u0005\u0015dBA\u0002B]fD!\"!\u001b\u0002\\\u0005\u0005\t\u0019AA+\u0003\rAH%\r\u0005\n\u0003[\u0002\u0011\u0011!C!\u0003_\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0002b!a\u001d\u0002z\u0005\u0005TBAA;\u0015\r\t9HD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA>\u0003k\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u007f\u0002\u0011\u0011!C\u0001\u0003\u0003\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\u000bI\tE\u0002\u000e\u0003\u000bK1!a\"\u000f\u0005\u001d\u0011un\u001c7fC:D!\"!\u001b\u0002~\u0005\u0005\t\u0019AA1\u0011%\ti\tAA\u0001\n\u0003\ny)\u0001\u0005iCND7i\u001c3f)\t\t)\u0006C\u0005\u0002\u0014\u0002\t\t\u0011\"\u0011\u0002\u0016\u0006AAo\\*ue&tw\r\u0006\u0002\u0002B!I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00131T\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0015Q\u0014\u0005\u000b\u0003S\n9*!AA\u0002\u0005\u0005t!CAQ\u0005\u0005\u0005\t\u0012AAR\u0003%\u0001V\u000f^(cU\u0016\u001cG\u000fE\u0002?\u0003K3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qU\n\u0005\u0003Kcq\u0004C\u0004;\u0003K#\t!a+\u0015\u0005\u0005\r\u0006BCAJ\u0003K\u000b\t\u0011\"\u0012\u0002\u0016\"Q\u0011\u0011WAS\u0003\u0003%\t)a-\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005\u0005UF#B\u001f\u00028\u0006e\u0006BB\u0012\u00020\u0002\u000fQ\u0005\u0003\u0004.\u0003_\u0003\u001da\f\u0005\u000b\u0003{\u000b)+!A\u0005\u0002\u0006}\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\u000b\t\rC\u0005\u0002D\u0006m\u0016\u0011!a\u0001{\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\u001d\u0017QUA\u0001\n\u0013\tI-A\u0006sK\u0006$'+Z:pYZ,GCAAf!\u0011\t\u0019%!4\n\t\u0005=\u0017Q\t\u0002\u0007\u001f\nTWm\u0019;")
public class PutObject
implements LazyLogging,
Product,
scala.Serializable {
    private final Provider provider;
    private final Materializer mat;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static boolean unapply(PutObject putObject) {
        return PutObject$.MODULE$.unapply(putObject);
    }

    public static PutObject apply(Provider provider, Materializer materializer) {
        return PutObject$.MODULE$.apply(provider, materializer);
    }

    private Logger logger$lzycompute() {
        PutObject putObject = this;
        synchronized (putObject) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Provider provider() {
        return this.provider;
    }

    public Materializer mat() {
        return this.mat;
    }

    public Function1<RequestContext, Future<RouteResult>> route(String bucket, String path) {
        return Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.put()).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)request -> Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.headerValueByName("authorization"), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)auth -> this.completeSigned(bucket, path))).$tilde(this.completePlain(bucket, path))))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable & scala.Serializable)() -> this.completePlain(bucket, path)));
    }

    public Function1<RequestContext, Future<RouteResult>> completeSigned(String bucket, String path) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)request -> Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("put object {}/{} (signed)", (Object[])new String[]{bucket, path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Future result = (Future)((Source)request.entity().dataBytes().via((Graph)new S3ChunkedProtocolStage()).fold((Object)ByteString$.MODULE$.apply(""), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.$plus$plus(x$2)).map((Function1 & Serializable & scala.Serializable)data -> {
                byte[] bytes = (byte[])data.toArray(ClassTag$.MODULE$.Byte());
                ObjectMetadata metadata = this.populateObjectMetadata((HttpRequest)request, bytes);
                boolean bl = false;
                Failure failure = null;
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.provider().putObject(bucket, path, bytes, metadata));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    BoxedUnit boxedUnit = (BoxedUnit)success.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 == null) {
                        if (boxedUnit3 == null) return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4());
                    } else if (boxedUnit2.equals(boxedUnit3)) {
                        return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4());
                    }
                }
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (e instanceof NoSuchBucketException) {
                        NoSuchBucketException noSuchBucketException = (NoSuchBucketException)e;
                        StatusCodes.ClientError x$5 = StatusCodes$.MODULE$.NotFound();
                        HttpEntity.Strict x$6 = HttpEntity$.MODULE$.apply(noSuchBucketException.toXML().toString());
                        Seq x$7 = HttpResponse$.MODULE$.apply$default$2();
                        HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
                        return HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8);
                    }
                }
                if (!bl) throw new MatchError((Object)try_);
                Throwable t = failure.exception();
                StatusCodes.ServerError x$9 = StatusCodes$.MODULE$.InternalServerError();
                HttpEntity.Strict x$10 = HttpEntity$.MODULE$.apply(new InternalErrorException(t).toXML().toString());
                Seq x$11 = HttpResponse$.MODULE$.apply$default$2();
                HttpProtocol x$12 = HttpResponse$.MODULE$.apply$default$4();
                return HttpResponse$.MODULE$.apply((StatusCode)x$9, x$11, (ResponseEntity)x$10, x$12);
            })).runWith((Graph)Sink$.MODULE$.head(), this.mat());
            return ToResponseMarshallable$.MODULE$.apply((Object)result, Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse()));
        }));
    }

    public Function1<RequestContext, Future<RouteResult>> completePlain(String bucket, String path) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)request -> Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("put object {}/{} (unsigned)", (Object[])new String[]{bucket, path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Future result = (Future)((Source)request.entity().dataBytes().fold((Object)ByteString$.MODULE$.apply(""), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$plus$plus(x$4)).map((Function1 & Serializable & scala.Serializable)data -> {
                byte[] bytes = (byte[])data.toArray(ClassTag$.MODULE$.Byte());
                ObjectMetadata metadata = this.populateObjectMetadata((HttpRequest)request, bytes);
                boolean bl = false;
                Failure failure = null;
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.provider().putObject(bucket, path, bytes, metadata));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    BoxedUnit boxedUnit = (BoxedUnit)success.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 == null) {
                        if (boxedUnit3 == null) return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4());
                    } else if (boxedUnit2.equals(boxedUnit3)) {
                        return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4());
                    }
                }
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (e instanceof NoSuchBucketException) {
                        NoSuchBucketException noSuchBucketException = (NoSuchBucketException)e;
                        StatusCodes.ClientError x$13 = StatusCodes$.MODULE$.NotFound();
                        HttpEntity.Strict x$14 = HttpEntity$.MODULE$.apply(noSuchBucketException.toXML().toString());
                        Seq x$15 = HttpResponse$.MODULE$.apply$default$2();
                        HttpProtocol x$16 = HttpResponse$.MODULE$.apply$default$4();
                        return HttpResponse$.MODULE$.apply((StatusCode)x$13, x$15, (ResponseEntity)x$14, x$16);
                    }
                }
                if (!bl) throw new MatchError((Object)try_);
                Throwable t = failure.exception();
                StatusCodes.ServerError x$17 = StatusCodes$.MODULE$.InternalServerError();
                HttpEntity.Strict x$18 = HttpEntity$.MODULE$.apply(new InternalErrorException(t).toXML().toString());
                Seq x$19 = HttpResponse$.MODULE$.apply$default$2();
                HttpProtocol x$20 = HttpResponse$.MODULE$.apply$default$4();
                return HttpResponse$.MODULE$.apply((StatusCode)x$17, x$19, (ResponseEntity)x$18, x$20);
            })).runWith((Graph)Sink$.MODULE$.head(), this.mat());
            return ToResponseMarshallable$.MODULE$.apply((Object)result, Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse()));
        }));
    }

    /*
     * WARNING - void declaration
     */
    private ObjectMetadata populateObjectMetadata(HttpRequest request, byte[] bytes) {
        void var3_3;
        ObjectMetadata metadata = new ObjectMetadata();
        HashSet<String> ignoredHeaders = new HashSet<String>();
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-amz-request-id");
        ignoredHeaders.add("x-amz-id-2");
        ignoredHeaders.add("X-Amz-Cf-Id");
        ignoredHeaders.add("Connection");
        Iterable headers = request.getHeaders();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(headers).asScala()).foreach((Function1 & Serializable & scala.Serializable)header -> {
            PutObject.$anonfun$populateObjectMetadata$1(this, metadata, header);
            return BoxedUnit.UNIT;
        });
        if (metadata.getContentType() == null) {
            metadata.setContentType(request.entity().getContentType().toString());
        }
        metadata.getRawMetadata();
        metadata.setContentMD5(DigestUtils.md5Hex((byte[])bytes));
        return var3_3;
    }

    public PutObject copy(Provider provider, Materializer mat) {
        return new PutObject(provider, mat);
    }

    public String productPrefix() {
        return "PutObject";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PutObject;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof PutObject;
        return bl && ((PutObject)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$populateObjectMetadata$1(PutObject $this, ObjectMetadata metadata$3, HttpHeader header) {
        block21: {
            String key = header.name();
            if (StringUtils.beginsWithIgnoreCase((String)key, (String)"x-amz-meta-")) {
                key = key.substring("x-amz-meta-".length());
                metadata$3.addUserMetadata(key, header.value());
            } else if (key.equalsIgnoreCase("Last-Modified")) {
                try {
                    metadata$3.setHeader(key, (Object)ServiceUtils.parseRfc822Date((String)header.value()));
                }
                catch (Exception pe) {
                    BoxedUnit boxedUnit;
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn("Unable to parse last modified date: " + header.value(), (Throwable)pe);
                        boxedUnit = BoxedUnit.UNIT;
                        break block21;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (key.equalsIgnoreCase("Content-Length")) {
                    try {
                        metadata$3.setHeader(key, (Object)BoxesRunTime.boxToLong((long)Long.parseLong(header.value())));
                    }
                    catch (NumberFormatException nfe) {
                        throw new AmazonClientException("Unable to parse content length. Header 'Content-Length' has corrupted data" + nfe.getMessage(), (Throwable)nfe);
                    }
                }
                if (key.equalsIgnoreCase("ETag")) {
                    metadata$3.setHeader(key, (Object)ServiceUtils.removeQuotes((String)header.value()));
                } else if (key.equalsIgnoreCase("Expires")) {
                    try {
                        metadata$3.setHttpExpiresDate(DateUtils.parseRFC822Date((String)header.value()));
                    }
                    catch (Exception pe) {
                        BoxedUnit boxedUnit;
                        if ($this.logger().underlying().isWarnEnabled()) {
                            $this.logger().underlying().warn("Unable to parse http expiration date: " + header.value(), (Throwable)pe);
                            boxedUnit = BoxedUnit.UNIT;
                            break block21;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (key.equalsIgnoreCase("x-amz-mp-parts-count")) {
                    try {
                        metadata$3.setHeader(key, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(header.value())).toInt()));
                    }
                    catch (NumberFormatException nfe) {
                        throw new AmazonClientException("Unable to parse part count. Header x-amz-mp-parts-count has corrupted data" + nfe.getMessage(), (Throwable)nfe);
                    }
                } else {
                    metadata$3.setHeader(key, (Object)header.value());
                }
            }
        }
    }

    public PutObject(Provider provider, Materializer mat) {
        this.provider = provider;
        this.mat = mat;
        LazyLogging.$init$((LazyLogging)this);
        Product.$init$((Product)this);
    }
}

