#!/usr/bin/python
#
#

import sys
import os
import re
import xml.etree.ElementTree

class Box:
    def __init__(self,id,directory,subdirs,dirlength,compression,
                 state,date):
        self.id=id
        self.directory=directory
        self.subdirs=int(subdirs)
        self.dirlength=int(dirlength)
        self.compression=compression
        self.state=state
        self.date=date
        self.journalfiles=[]
        journaldir=self.directory+os.sep+'journal'

        namepattern=re.compile('^.+journal(\.gz)?$')
        for file in os.listdir(journaldir):
            if not namepattern.match(file):
                continue
            self.journalfiles.append(journaldir+os.sep+file)


    def fileFromHash(self,hashvalue):
        '''Returns path to bennofile gerated from hash value'''
        suffix='.gz'
        result=[]
        start=0
        for i in range(self.subdirs):
            slice=hashvalue[start:start+self.dirlength]
            result.append(slice)
            start=start+self.dirlength
        slice=hashvalue[start:]
        result.append(slice)
        path=(os.sep).join(result)
        path=self.directory+os.sep+path+suffix
        return path


    def GetBoxes(boxstatefile):
        '''Returns a list of box objects from boxstatefile'''
        try:
            boxxml=xml.etree.ElementTree.parse(boxstatefile).getroot()
        except IOError, e:
            sys.exit('Cannot open boxstate file: "%s": %s' % (boxstatefile,e[1]))
        boxes=[]
        boxlist={}
        for box in boxxml.findall("box"):
            boxid=box.get("identifier")
            boxbox=box.find('box')
            boxstate=boxbox.get('state')
            boxdate=boxbox.get('opened')
            boxlist[boxid] = [boxbox,boxstate,boxdate]
        # sort boxes ascending
        for boxid in sorted(boxlist): 
            boxentry=boxlist[boxid][0]
            for boxbox in list(boxentry):
                boxdir=boxbox.find('directory').text
                subdirs=boxbox.find('subdirs').text
                dirlength=boxbox.find('dirlength').text
                compression=boxbox.find('compression').text
                box=Box(boxid,boxdir,subdirs,dirlength,compression,boxstate,boxdate)
            boxes.append(box)
        return boxes

    GetBoxes=staticmethod(GetBoxes)    


