#!/usr/bin/python
#
#

import sys
import os

class Journal:
    '''Holds all journal objects'''
    def __init__(self):
        self.journals={}
        self.first=''
        self.last=''

    def add(self,journalfile):
        self.journals[journalfile.hash]=journalfile
        if journalfile.first:
            self.first=journalfile.hash
        if journalfile.last:
            self.last=journalfile.hash

    def getPredecessor(self,hash):
        return self.journals[hash]

    def getLast(self):
        return self.journals[self.last]

    def getFirst(self):
        return self.journals[self.first]

    def getJournalfiles(self):
        '''Returns array of journalfile objects from newest to oldest'''
        journalfiles=[]
        curJournal=self.getLast()
        while True:
            journalfiles.append(curJournal)
            try:
                curJournal=self.getPredecessor(curJournal.preHash)
            except KeyError:
                break
        return journalfiles
    
    def count(self):
        return len(self.journals)


