#
#
#
import sys
import os
import tarfile
import Benno

def fromConfig(configfile,args):
    for container in Benno.Config(configfile).containers:
        repo=container.getRepo()
        if args.full:
            statusfile=False
        elif args.statusfile:
            statusfile=args.statusfile
        else:    
            statusfile=repo.path+os.sep+'backup.status'
        if args.purge_status:
            try:
                if args.verbose > 0: print >> sys.stderr, "Remove status file: %s" % statusfile
                os.remove(statusfile)
            except:
                pass
        if args.verbose > 0: print >> sys.stderr, "Status file: %s" % statusfile

        oldhash=''
        if statusfile:
            try:
                f=open(statusfile)
                oldhash=f.readline().rstrip()
                f.close()
            except IOError: pass
        if args.tarfile:
            newesthash=writeTar(repo,oldhash,args)
        else:
            newesthash=printFiles(repo,oldhash,args)
        if statusfile:
            f=open(statusfile,'w')
            f.write(newesthash+"\n")
            f.close()
    return 0


def fromRepo(args):
    repo=Benno.Repo(args.repo)
    if args.full:
        statusfile=False
    elif args.statusfile:
        statusfile=args.statusfile
    else:    
        statusfile=repo.path+os.sep+'backup.status'
        if args.purge_status:
            try:
                if args.verbose > 0: print >> sys.stderr, "Remove status file: %s" % statusfile
                os.remove(statusfile)
            except:
                pass
    if args.verbose > 0: print >> sys.stderr, "Status file: %s" % statusfile

    oldhash=''
    if statusfile:
        try:
            f=open(statusfile)
            oldhash=f.readline().rstrip()
            f.close()
        except IOError: pass
    newesthash=printFiles(repo,oldhash,args)
    if statusfile:
        f=open(statusfile,'w')
        f.write(newesthash+"\n")
        f.close()
    return 0


############################################################################
def writeTar(repo,oldhash,args):
    journal=Benno.Journal()
    for box in Benno.Box.GetBoxes(repo.boxstate):
        for journalfile in box.journalfiles:
            journaldata=Benno.Journalfile(box,journalfile)
            journal.add(journaldata)
    journalfiles=journal.getJournalfiles()
    newesthashlist=journalfiles[0].getHashes()
    try:
        newesthash=newesthashlist[0]
    except IndexError: pass

    reposubdir=os.path.basename(repo.path)
    if args.tarfile=='-':
        tar=tarfile.open(fileobj=sys.stdout,mode='w|')
    else:
        tar=tarfile.open(args.tarfile,'w')
    for jfile in journalfiles:
        currenthash=''
        mailhashes=jfile.getHashes()
        jFileName=jfile.file
        path,repoJfileName=jFileName.split(reposubdir)
        backupJfileName=reposubdir+repoJfileName
        tar.add(jfile.file,backupJfileName)
        for currenthash in mailhashes:
            if currenthash==oldhash:
                tar.close()
                return newesthash
            file2backup=jfile.box.fileFromHash(currenthash)
            path,repoFileName=file2backup.split(reposubdir)
            backupFileName=reposubdir+repoFileName
            try:
                tar.add(file2backup,backupFileName)
            except OSError, e:
                print >> sys.stderr, "ERROR: Cannot add \"%s\" to tar archive: \"%s\"" % (file2backup,e[1])
            except KeyboardInterrupt:
                sys.exit("Exit.")
    tar.close()
    return newesthash


def printFiles(repo,oldhash,args):
    journal=Benno.Journal()
    for box in Benno.Box.GetBoxes(repo.boxstate):
        for journalfile in box.journalfiles:
            journaldata=Benno.Journalfile(box,journalfile)
            journal.add(journaldata)
    journalfiles=journal.getJournalfiles()
    newesthashlist=journalfiles[0].getHashes()
    try:
        newesthash=newesthashlist[0]
    except IndexError: pass
    reposubdir=os.path.basename(repo.path)
    for jfile in journalfiles:
        currenthash=''
        mailhashes=jfile.getHashes()
        jFileName=jfile.file
        path,repoJfileName=jFileName.split(reposubdir)
        print "%s" % reposubdir+repoJfileName
        for currenthash in mailhashes:
            if currenthash==oldhash:
                return newesthash
            print "%s" % jfile.box.fileFromHash(currenthash)
    return newesthash

