#
import sys
import os
import Benno


def configFile(configfile,args):
    retval=0
    for container in Benno.Config(configfile).containers:
        repodir=container.getRepo().path
        ret_dir=repoDir(repodir,args)
        retval=retval+ret_dir
    sys.exit(retval)


def repoDir(repodir,args):
    retval=0
    ret_jrnl=Benno.verify.journal(repodir,args)
    retval=retval+ret_jrnl
    if args.archive:
        try:
            ret_arch=Benno.verify.archive(repodir,args)
            retval=retval+ret_arch
        except KeyboardInterrupt:
            print "Exit."
            sys.exit(1)
    return retval


############################################################################
def journal(repodir,args):
    if args.verbose > 0: print "Check journalchain in repo %s" % repodir
    retval=0
    repo=Benno.Repo(repodir)
    journal=Benno.Journal()

    if args.verbose > 1: print " Load boxes from %s." % repo.boxstate
    for box in Benno.Box.GetBoxes(repo.boxstate):
        if args.verbose > 2: print "  Examine box: %s" % box.id
        for journalfile in box.journalfiles:
            if args.verbose > 3: print "  Load journal %s." % journalfile
            try:
                journaldata=Benno.Journalfile(box,journalfile)
                journal.add(journaldata)
            except ValueError, e:
                print >> sys.stderr, "WARN: Ignore %s: %s" % (journalfile,e)

    if args.verbose > 1: print " Check journalchain digests of %s." % repodir
    jfirst=journal.getFirst()
    jlast=journal.getLast()
    while True:
        try:
            # walk chain from last > first
            jpre=journal.getPredecessor(jlast.preHash)
            if args.verbose > 3: print "   Check chainpart %s < %s." % (jlast.journalId(),jpre.journalId())
            if not jpre.hash == jlast.preHash:
                print >> sys.stderr, "VERIFY ERROR: %s modified." % jpre.journalfile
                retval=1
            jlast=jpre
        except KeyError:
            break

    if jlast.hash == jfirst.hash:
        print "OK: Journal chain of %s successful verified." % repodir
    else:
        print >> sys.stderr, "ERROR: Predecessor of %s not found!" % jlast.journalId()
        retval=1

    return retval



def archive(repodir,args):
    if args.verbose > 0: print "Check files in %s." % repodir
    retval=0
    repo=Benno.Repo(repodir)
    journal=Benno.Journal()

    if args.verbose > 1: print " Load boxes from %s." % repo.boxstate
    for box in Benno.Box.GetBoxes(repo.boxstate):
        if args.verbose > 2: print "  Examine box: %s" % box.id
        for journalfile in box.journalfiles:
            if args.verbose > 3: print "  Load journal %s." % journalfile
            journaldata=Benno.Journalfile(box,journalfile)
            journal.add(journaldata)

    if args.verbose > 1: print " Check archive files with journal entry checksum."
    journalfiles=journal.getJournalfiles()
    for jfile in journalfiles:
        box=jfile.box
        if args.verbose > 2: print "  Check files in box %s." % box.id
        mailhashes=jfile.getHashes()
        for hash in mailhashes:
            filepath=box.fileFromHash(hash)
            if args.verbose > 4: print "    Check archive file %s:" % filepath,
            try:
                bennofile=Benno.BennoFile(filepath)
                if not bennofile.verifySelf():
                    if args.verbose > 0: print >> sys.stderr, "ERROR: File modified: %s." % filepath
                    retval=1
                    continue
                if not bennofile.verifyFilenameHash(hash):
                    if args.verbose > 0: print >> sys.stderr, "ERROR: Filename not match: %s." % filepath
                    continue
                    retval=1
                if args.verbose > 4: print "OK"
            except IOError as (errnr, strerror):
                    if args.verbose > 0: print >> sys.stderr, "ERROR: %s on %s." % (strerror,filepath)
                    retval=1
    if retval==0:
        print "OK: Archived files successful verified."
    else:
        print >> sys.stderr, "ERROR: Archived files not consistent"
    return retval


