import sys
import os
import gzip
import re
import hashlib
from optparse import OptionParser


class BennoFile:

    def __init__(self,filename):
        self.filename=filename
        self.cs_content=''
        self.cs_header=''
        self.mailcontent=''
        self.envelope=''
        self.header=True

        try:
            f=gzip.open(filename,'rb')
        except IOError, e:
            print >> sys.stderr, "ERROR: Cannot open %s: %s" % (filename,e[1])
            return None 
        for line in f:
            m=re.search('^===== Hash:\s(\S+)',line)
            if m:
                self.cs_header=m.group(1)
                self.header=False
                break
            try:
                p,v=line.split(':',1)
                if p == 'Recipient':
                    self.envelope=self.envelope+'X-REAL-RCPTTO:'+v
                if p == 'Sender':
                    self.envelope=self.envelope+'X-REAL-MAILFROM:'+v
            except ValueError, e:
                if args.verbose > 1: print >> sys.stderr, "WARN: Cannot parse Benno header of %s: %s" % (filename,line)

        self.mailcontent=f.read()
        f.close()
        if self.header:
            raise ValueError('No Benno header found')
        else:
            sha=hashlib.sha256()
            sha.update(self.mailcontent)
            self.cs_content=sha.hexdigest().upper()

    def digestContent(self):
        return self.cs_content

    def digestMeta(self):
        return self.cs_header

    def getEnvelope(self):
        return self.envelope

    def getMail(self):
        return self.mailcontent

    def verifySelf(self):
        '''Verify content against header digest value'''
        if self.cs_header==self.cs_content:
            return True
        else:
            return False

    def verifyDigest(self,digest):
        '''Verify mail content against given digest'''
        ## remove padding tail '00'
        #if digest.endswith('00'):
        #    digest=digest[:-2]
        if self.cs_content==digest:
            return True
        else:
            return False

    def verifyFilenameHash(self,digest):
        '''Verify mail content against given digest'''
        # remove padding tail '00'
        if digest.endswith('00'):
            digest=digest[:-2]
        if self.cs_content==digest:
            return True
        else:
            return False


