#
#
#
import re
import Benno.Repo
import Benno.Index

class Container:
    def __init__(self,xml):
        self.id=xml.find('identifier').text
        self.xml=xml
        self.__initIndex()
        self.__initRepo()


    def getIndex(self):
        return self.index


    def getRepo(self):
        return self.repo


    def __initIndex(self):
        version=self.xml.find('luceneindex').get('version')
        path=self.xml.find('luceneindex').find('directory').text
        self.index=Benno.Index(path,version)


    def __initRepo(self):
        re_fsbox = re.compile('^fs.+box$')
        for box in self.xml.iter('*'):
            if re_fsbox.match(box.tag):
                repodir=box.find('directory').text
                subdirs=box.find('subdirs').text
                dirlength=box.find('dirlength').text
                compression=box.find('compression').text
                self.repo=Benno.Repo(repodir,subdirs,dirlength,compression)

