#
#
#
import sys
import os
import tarfile
import Benno


def configFile(configfile,args):
    retval=0
    for container in Benno.Config(configfile).containers:
        repodir=container.getRepo().path
        ret_dir=repoDir(repodir,args)
        retval=retval+ret_dir
    sys.exit(retval)


def repoDir(repodir,args):
    retval=0
    repo=Benno.Repo(repodir)
    inbox=args.inbox
    if args.mailid:
        mailid=args.mailid
        try:
            boxid,hashval=mailid.split(':')
        except ValueError:
            print >> sys.stderr, "ERROR: Incorrect format of mailid (not <box>:<checksum>."
            return 3
        box=getBox(repo,boxid)
        filepath=box.fileFromHash(hashval)        
        if args.verbose > 0: print "Reindex: %s" % filepath
        copyFile(filepath,inbox,mailid,args)
        return retval

    if args.box:
        boxid=args.box
        journals=getJournals(repo)
        journalfiles=[]
        for journalfile in journals.getJournalfiles():
            if journalfile.box.id==boxid:
                journalfiles.append(journalfile)
        for jfile in journalfiles:
            hashlist=jfile.getHashes()
            try:
                for hashval in hashlist:
                    filepath=jfile.box.fileFromHash(hashval)        
                    if args.verbose > 1: print "Reindex %s" % filepath
                    mailid=boxid+':'+hashval
                    copyFile(filepath,inbox,mailid,args)
            except KeyboardInterrupt:
                if args.verbose > 0: print "Last reindexed id: %s" % mailid
                return 1
    return 99


def getJournals(repo):
    journal=Benno.Journal()
    for box in Benno.Box.GetBoxes(repo.boxstate):
        for journalfile in box.journalfiles:
            journaldata=Benno.Journalfile(box,journalfile)
            journal.add(journaldata)
    return journal


def getBox(repo,boxid):
    for box in Benno.Box.GetBoxes(repo.boxstate):
        if box.id==boxid:
            return box


def copyFile(filepath,inbox,mailid,args):
    bennoFile=Benno.BennoFile(filepath)
    basepath=tmppath=inbox+os.sep+mailid
    tmppath=basepath+'.reimport'
    emlpath=basepath+'.eml'
    if args.verbose > 2: print "Reimport %s -> %s" % (filepath,emlpath)
    try:
        tmpfile=open(tmppath,'w')        
        tmpfile.write(bennoFile.getEnvelope())
        tmpfile.write(bennoFile.getMail())
        tmpfile.close
        os.link(tmppath,emlpath)
        os.unlink(tmppath)
    except EnvironmentError, e:
        os.unlink(tmppath)
        print >> sys.stderr, "ERROR: Cannot write files %s.{reimport,eml}: %s" % (basepath,e[1])
    except Exception, e:
        print >> sys.stderr, "ERROR: Cannot reimport %s: %s" % (filepath,e)


