import sys
import os
import zipfile
import StringIO
import re
import socket
import Benno


def printConfig(configfile,args):
    config=Benno.Config(configfile)
    for container in config.containers:

            index=container.getIndex()
            if args.verbose == 0:
                print "  %-16s %s" % ('Index:',index.path)
            if args.verbose > 0:
                print "  %-16s" % 'Index'
                print "    %-14s %s" % ('path:',index.path)
                print "    %-14s %s" % ('version:',index.version)

            repo=container.getRepo()
            if args.verbose == 0:
                print "  %-16s %s" % ('Repo:',repo.path)
            if args.verbose > 0:
                print "  %-16s" % 'Repo'
                print "    %-14s %s" % ('path:',repo.path)
                print "    %-14s %s" % ('subdirs:',repo.subdirs)
                print "    %-14s %s" % ('dirlength:',repo.dirlength)
                print "    %-14s %s" % ('compression:',repo.compression)
                if args.verbose > 1:
                    if args.verbose <= 2:
                        print "  %-16s" % 'Boxes:',
                    if args.verbose > 2: print "  Boxes"
                    for box in Benno.Box.GetBoxes(repo.boxstate):
                        if args.verbose <= 2:
                            print "%s" % box.id,
                        if args.verbose > 2:
                            print "    %-14s %s" % (box.id+':',box.directory)


def printVersion(component,args):
    jarfile=''.join(component.split()).lower()
    if args.installdir:
        installdir=args.installdir
    else:
        installdir='/opt/benno'
    jarpath=installdir+os.sep+jarfile+'.jar'
    try:
        coreZip=zipfile.ZipFile(jarpath,'r')
    except IOError as (errnr, strerror):
        if errnr==2:
            return ''
    except zipfile.BadZipfile, e:
        if args.verbose >= 2:
            print "WARN: Cannot examine %s" % jarpath
        return '-'
    coreManifest=StringIO.StringIO(coreZip.read('META-INF/MANIFEST.MF'))
    coreZip.close()
    for line in coreManifest.readlines():
        if line.startswith(' '):
            continue
        try:
            p,v=line.split(': ')
            if not p=='Implementation-Version':
                continue
            version=v.rstrip()
        except ValueError:
            pass
    return version


def printWebVersion(component,args):
    try:
        versionfile='/srv/benno/bennoweb/htdocs/model/Benno.php'
        bv=open(versionfile,'r')
    except IOError:
        return
    for line in bv.readlines():
        try:
            m=re.search('^.*?infoText\s+=\s+\'Benno MailArchiv Version\s(\S+)\'',line)
            version=m.group(1)
        except AttributeError:
            continue
    return version


def printWebInfo(component,args):

    try:
        bennoconf='/etc/benno-web/benno.conf'
        bc=open(bennoconf,'r')
    except IOError:
        return
    baseurl=''
    authmodule=''
    for line in bc.readlines():
        if line.startswith('#'):
            continue
        try:
            p,v=line.split('=')
            param=p.strip()
            value=v.strip()
        except ValueError:
            continue
        if param=='BASE_URL':
            baseurl=value
        if param=='EXTERNAL_AUTH':
            authmodule=value
        if param=='DBTYPE':
            dbtype=value
    if not authmodule:
        authmodule=dbtype
    if args.verbose == 0:
            print "  %-16s %s" % (component+':',bennoconf)
    if args.verbose > 0:
        print "  %-16s" % (component)
        print "    %-14s %s" % ('config:',bennoconf)
        print "    %-14s %s" % ('authmodule:',authmodule)
        print "    %-14s %s" % ('rest url:',baseurl)


def printHostInfo(args):
    error=False
    errmsg=[]
    msg=''
    myhostname=socket.getfqdn()
    myhostaddr=socket.gethostbyname(myhostname)    
    if myhostname.find('.') == -1:
        error=True
        errmsg.append('No full qualified hostname.')
    if myhostaddr.startswith('127.'):
        error=True
        errmsg.append('Loopback address detected.')
    print "  %-16s %s%s%s" % ('Host-Info:',myhostaddr,'/',myhostname),
    if error:
        print "  %-16s" % 'Error(s):',
        for msg in errmsg:
            print "%s" % msg,
    print ""
