import sys
import os
import re
import xml.etree.ElementTree
import Benno.Container

class Config:
    def __init__(self,xmlfile):
        self.containers=[]
        self.rest=''
        try:
            bennoxml=xml.etree.ElementTree.parse(xmlfile).getroot()
        except IOError, e:
            sys.exit('Cannot open Benno config file: "%s": %s' % (xmlfile,e[1]))
        except SyntaxError, e:
            sys.exit('Cannot read configfile "%s": %s' % (configfile,e))
        for simplecontainer in bennoxml.iter('simplecontainer'):
            self.containers.append(Benno.Container(simplecontainer))
        bennorest=bennoxml.find('bennoRest')
        jettyconfig=bennorest.findtext('jettyConfig')
        sharedsecret=bennorest.findtext('sharedSecret')
        indexcachettl=bennorest.findtext('indexCacheTTL')
        self.rest=Benno.Rest(jettyconfig,sharedsecret,indexcachettl)
        

