import sys
import os
import tarfile
import Benno
import socket
import inspect

# single instance
try:
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.bind(('127.0.0.1', 27989))
    s.listen(1)
except socket.error as e:
    error_code = e.args[0]
    error_string = e.args[1]
    print >> sys.stderr, "Benno backup already running (%d:%s). Exit" % ( error_code, error_string) 
    sys.exit (0) 


def fromConfig(configfile,args):
    if args.tarfile and not args.list:
        if args.tarfile=='-':
            tar=tarfile.open(fileobj=sys.stdout,mode='w|')
        else:
            tar=tarfile.open(args.tarfile,'a')

    for container in Benno.Config(configfile).containers:
        if args.verbose > 0: print >> sys.stderr, "Backup container: %s" % container.id
        repo=container.getRepo()
        if args.increment:
            statusfile=repo.path+os.sep+'backup.status'
        else:
            statusfile=False
        if args.statusfile:
            statusfile=args.statusfile
        if args.purge_status:
            try:
                if args.verbose > 0: print >> sys.stderr, "Remove status file: %s" % statusfile
                os.remove(statusfile)
            except:
                pass
        if args.verbose > 0: print >> sys.stderr, "Status file: %s" % statusfile

        oldhash=''
        if statusfile:
            try:
                f=open(statusfile)
                oldhash=f.readline().rstrip()
                f.close()
            except IOError: pass
        if args.tarfile and not args.list:
            # tar output
            newesthash=tarOutput(args,repo,oldhash,statusfile,tar)
        else:
            # filename output
            newesthash=fileOutput(args,repo,oldhash,statusfile)
        if statusfile:
            f=open(statusfile,'w')
            f.write(newesthash+"\n")
            f.close()

    try:
        tar.close()
    except UnboundLocalError: pass
    return 0


def fromRepo(args):
    if args.tarfile and not args.list:
        if args.tarfile=='-':
            tar=tarfile.open(fileobj=sys.stdout,mode='w|')
        else:
            tar=tarfile.open(args.tarfile,'a')

    repo=Benno.Repo(args.repo)
    if args.increment:
        statusfile=args.repo+os.sep+'backup.status'
    else:
        statusfile=False
    if args.statusfile:
        statusfile=args.statusfile
    if args.purge_status:
        try:
            if args.verbose > 0: print >> sys.stderr, "Remove status file: %s" % statusfile
            os.remove(statusfile)
        except:
            pass
    if args.verbose > 0: print >> sys.stderr, "Status file: %s" % statusfile
    oldhash=''
    if statusfile:
        try:
            f=open(statusfile)
            oldhash=f.readline().rstrip()
            f.close()
        except IOError: pass
    if args.tarfile and not args.list:
        # tar output
        newesthash=tarOutput(args,repo,oldhash,statusfile,tar)
    else:
        # filename output
        newesthash=fileOutput(args,repo,oldhash,statusfile)

    if statusfile:
        f=open(statusfile,'w')
        f.write(newesthash+"\n")
        f.close()

    try:
        tar.close()
    except UnboundLocalError: pass
    return 0




############################################################################
def fileOutput(args,repo,oldhash,statusfile):
    if statusfile and os.path.isfile(statusfile):
        print statusfile
    newesthash=printFiles(repo,oldhash,args)
    return newesthash
 

############################################################################
def tarOutput(args,repo,oldhash,statusfile,tar):
    newesthash=writeTar(repo,oldhash,args,tar)
    if statusfile and os.path.isfile(statusfile):
        tar.add(statusfile)
    return newesthash


############################################################################
def writeTar(repo,oldhash,args,tar):
    journal=Benno.Journal()
    #for box in Benno.Box.GetBoxes(repo.boxstate):
    for box in Benno.Box.GetBoxNames(repo.path):
        for journalfile in box.journalfiles:
            journaldata=Benno.Journalfile(box,journalfile)
            journal.add(journaldata)
    journalfiles=journal.getJournalfiles()
    newesthashlist=journalfiles[0].getHashes()
    try:
        newesthash=newesthashlist[0]
    except IndexError: pass

    tar.add(repo.getBoxstate())
    reposubdir=repo.path
    for jfile in journalfiles:
        currenthash=''
        mailhashes=jfile.getHashes()
        jFileName=jfile.file
        path,repoJfileName=jFileName.rsplit(reposubdir,1)
        backupJfileName=reposubdir+repoJfileName
        if args.verbose > 2: print >> sys.stderr, "Add file %s" % backupJfileName
        tar.add(jfile.file,backupJfileName)
        for currenthash in mailhashes:
            if currenthash==oldhash:
                return newesthash

            file2backup=jfile.box.fileFromHash(currenthash)
            path,repoFileName=file2backup.split(reposubdir)
            backupFileName=reposubdir+repoFileName
            try:
                tar.add(file2backup,backupFileName)
                tar.members=[]
            except OSError, e:
                print >> sys.stderr, "ERROR: Cannot add \"%s\" to tar archive: \"%s\"" % (file2backup,e[1])
            except KeyboardInterrupt:
                sys.exit("Exit.")
    return newesthash


# print full path of repo file
def printFiles(repo,oldhash,args):
    journal=Benno.Journal()
    #for box in Benno.Box.GetBoxes(repo.boxstate):
    for box in Benno.Box.GetBoxNames(repo.path):
        for journalfile in box.journalfiles:
            journaldata=Benno.Journalfile(box,journalfile)
            journal.add(journaldata)
    journalfiles=journal.getJournalfiles()
    newesthashlist=journalfiles[0].getHashes()
    try:
        newesthash=newesthashlist[0]
    except IndexError: pass
    reposubdir=os.path.basename(repo.path)
    print repo.getBoxstate()
    for jfile in journalfiles:
        currenthash=''
        mailhashes=jfile.getHashes()
        print "%s" % jfile.file
        for currenthash in mailhashes:
            if currenthash==oldhash:
                return newesthash
            print "%s" % jfile.box.fileFromHash(currenthash)
    return newesthash

