package Benno::Config;

use XML::LibXML;
use strict;
use Benno::Container;


=head1 SYNOPSIS

    use Benno::Config;

    my $BC = new Benno::Config($configfile);

=cut

=head1 METHODS

=head2 new($configfile)

    my $BC = new Benno::Config($configfile);

    $BC->add_container($BennoContainer);
    $BC->get_container($container_id);

    $BC->get_config($parametername);
    $BC->set_config($parametername,$value);

    my @containerids = $BC->get_containerids();

    my @containerlist = $BC->get_containers();

=cut
sub new
{
    my $class       = shift;
    my ($filename)  = @_;

    my $self = {
        filename  => $filename,
        inbox     => '',
        containers => {},
        secreatheader => [],
    };
    bless $self, $class;

    $self->_init();

    return $self;
}


sub add_container
{
    my ($self,$Cnt) = @_;

    $self->{containers}->{$Cnt->{id}} = $Cnt;
}


sub get_config
{
    my ($self,$attr) = @_;

    return $self->{config}->{$attr};
}


sub get_container
{
    my ($self,$cid) = @_;

    return $self->{containers}->{$cid};
}


sub get_containers
{
    my ($self) = @_;

    my @retlist;
    foreach my $cid (keys %{$self->{containers}}) {
        push @retlist, $self->{containers}->{$cid};
    }

    return @retlist;
}


sub get_containerids
{
    my ($self) = @_;

    my @retlist;
    foreach my $cid (keys %{$self->{containers}}) {
        push @retlist, $cid;
    }

    return @retlist;
}


sub get_secretheader
{
    return @{$_[0]->{secretheader}};
}


sub id
{
    my ($self) = @_;

    return $self->{id};
}


sub inbox
{
    my ($self) = @_;

    return $self->{inbox};
}



sub set_config
{
    my ($self,$attr,$value) = @_;

    $self->{config}->{$attr} = $value;
}


sub _init
{
    my ($self) = @_;

    my $dom = XML::LibXML->load_xml(location => $self->{filename});

    my $dwatcher = $dom->findnodes('//directorywatcher')->shift;
    $self->{inbox} = $dwatcher->getAttribute('directory');

    my $shs = $dom->findnodes('//directorywatcher/mailfile/secretheaders');
    foreach my $sh (split /\R/, $shs) {
        $sh =~ s/\s//g;
        next if $sh =~ /^$/;
        push @{$self->{secretheader}}, $sh;
    }

    # load Container
    foreach my $xml ($dom->findnodes('//simplecontainer')) {
        $self->add_container(new Benno::Container($xml));
    }
}





### EOP ###
1;
