package Benno::REST::Client;
use LWP::UserAgent;
use MIME::Base64;

=head1 NAME

Benno::REST::Client - REST Client class


=head1 SYNOPSIS

    use Benno::REST::Client;

    my $RC = new Benno::REST::Client($filepath);

=cut

=head1 METHODS

=head2 new($uri,%params)

    - uri - REST endpoint uri
    - params - rest parameter

=over

=item ssl_verify => $mode

    Set SSL_varify_mode to $mode.

=item username => $username

    Set username for authorization.

=item password => $password

    Set password for authorization.

=item auth_type => 'Benno-API'

    Set authorization type != "Basic".

=item authstring => xyz123

    Set authorization string, will be base64 encoded before sent.

=cut


sub new {
    my $class = shift;
    my ($uri,%vars) = @_;

    $vars{ssl_verify} = 0       unless defined $vars{'ssl_verify'};
    $vars{auth_type}  = 'Basic' unless defined $vars{'auth_type'};

    my $self = \%vars;
    bless $self, $class;

    my $UA = LWP::UserAgent->new(
                ssl_opts => {
                verify_hostname => 0, # will be removed in LWP::UserAgent > 6.06
                SSL_verify_mode => $vars{ssl_verify}, # LWP::UserAgent >= 6.05
                });

    $self->{_UA}  = $UA;
    $self->{_uri} = $uri;

    return $self;
}

=head2 send($mail_content)

    Send mail_content to REST backend.

=cut

sub send
{
    my ($self,$mail_content) = @_;

    my $Response;
    my $msg = '';

    if ($self->{username} and $self->{password}) {
        $authstring = encode_base64($self->{username}.':'.$self->{password});
    }
    else {
        $authstring = $self->{authstring}
            or die "No authentication information\n";
    }


    $Response = $self->{UA}->put(
        $self->{uri},  
        Authorization   => $self->{auth_type}.' '.encode_base64($authstring),
        Content         => $mail_content,
    );

    my $return;
    if ($Response->is_success) {
        $return = $Response->decoded_content;
        $return =~ s/\r//g;
        if ($return =~ /^OK\s(.+?)$/) {
            return $1;
        }
        else {
            die 'RESPONSE ERROR '.$Response->status_line,"\n";
        }
    }

    die 'HTTP ERROR '.$Response->status_line,"\n";
}


### EOP ###
1;

