package Benno::Export::SMTP;
use MIME::Lite;

=head1 NAME

Benno::Export::SMTP - Export Benno::Emlfile object as BENNO-JOURNALREPORT

=head1 SYNOPSIS

    use Benno::Export::SMTP;

    my $Export = new Benno::Export::SMTP($sender,$recipient,$Emlfile)

=head1 METHODS

=head2 new($sender,$recipient,$Emlfile)

Create Benno::Export::SMTP object.

=cut
sub new
{
    my $class = shift;
    my ($sender,$recipient,$mailfile) = @_;

    my $self = {
        sender          => $sender,
        recipient       => $recipient,
        journalheader   => 'X-BENNO-JOURNALREPORT',
        mailfile        => $mailfile,
    };
    bless $self, $class;

    return $self;
}


=head2 content()

    Return journalmail content als string.

=cut    
sub content
{
    my ($self) = @_;
    return $self->_prepare->as_string;
}


=head2 send

    Send MIME::Lite object

=cut    
sub send
{
    my ($self,@args) = @_;
    return $self->_prepare->send(@args);
}


=head2 set_journalheader('X-MS-Journal-Report')

    Set journalheader to another value.
    Default: X-BENNO-JOURNALREPORT

=cut    
sub set_journalheader
{
    my ($self,$value) = @_;
    return $self->{journalheader} = $value;
}



sub _prepare
{
    my ($self) = @_;

    my $body, $mailobj;

    my $envelope_sender = 0;
    my $envelope_recipient = 0;
    if (my $envelope_from = $self->{mailfile}->envelope_from) {
        $body = 'Sender: '.$self->{mailfile}->envelope_from."\r\n";
        $envelope_sender = 1;
    }
    foreach my $address ($self->{mailfile}->envelope_to) {
        $body .= 'Recipient: '.$address."\r\n";
        $envelope_recipient = 1;
    }
    foreach my $val ($self->{mailfile}->gw) {
        $body .= 'X-BENNO-GW: '.$val."\r\n";
    }
    foreach my $val ($self->{mailfile}->scid) {
        $body .= 'X-BENNO-SCID: '.$val."\r\n";
    }

    $envelope_sender || $envelope_recipient || die "No sender or recipient metadata set!\n";

    $mailobj = MIME::Lite->new(
        From    => $self->{sender},
        To      => $self->{recipient},
        Subject => 'Journalmail '.$self->{mailfile}->digest,
        Type    => 'multipart/mixed',
    );
    $mailobj->add($self->{journalheader},$self->{mailfile}->digest);
    $mailobj->attach(Type => 'text/plain',     Data => $body);
    $mailobj->attach(Type => 'message/rfc822', Data => $self->{mailfile}->base_content);

    return $mailobj;
}


### EOP ###
1;
