package Benno::Log;

### Benno::Log->new($logfile);
sub new
{
    my $class = shift;
    my ($filepath) = @_;

    my $self = {};
    bless $self, $class;

    $self->_open_log($filepath);

    return $self;
}


sub _open_log
{
    # increment counter for logging
    my ($self,$filepath) = @_;
    my $logfile;

    $filepath = './'.$filepath unless $filepath =~ m!^/!;
    my ($dirname,$basename)     = $filepath =~ m!(.*?)/([^/]+?)$!;
    my ($fileprefix,$filecount) = $basename =~ m!(.*)-(\d+)\.log$!;
    if ($filecount) {
        $filecount++;
        $logfile = $dirname.'/'.$fileprefix.'-'.$filecount.'.log';
    }
    else {
        $filecount = 1;
        $fileprefix = $basename;
        $logfile = $dirname.'/export_rest-'.$fileprefix.'-'.$filecount.'.log';
    }
    $logfile =~ s{//}{}g;


    if (-f $logfile) { # file exists
        return $self->_open_log($logfile);
    }
    else {
        open(my $logfh,'>>',$logfile) or die "Cannot open logfile $logfile: $!\n";
        $self->{logfile} = $logfile;
        $self->{logfh} = $logfh;
        return $logfile;
    }
}


### logging
sub write
{
    my ($self,$msg) = (@_);

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
    #                         0-11,+1900,0-6  ,0-366,SZ=(+)
    #                                   ,So-Sa,0-366,WZ=0,NA=(-)

    $year += 1900;
    $mon  += 1; $mon = sprintf("%02d",$mon);
    $mday = sprintf("%02d",$mday);
    $hour = sprintf("%02d",$hour);
    $min  = sprintf("%02d",$min);
    $sec  = sprintf("%02d",$sec);
    my $ts = $year.'-'.$mon.'-'.$mday.' '.$hour.':'.$min.':'.$sec;

    my $logfh = $self->{logfh};
    $msg =~ s/\R//;
    $msg = "$ts $msg\n";

    print $logfh $msg;
    $logfh->flush();
}


## logfile
sub logfile
{
    my ($self) = @_;
    return $self->{logfile};
}


### verbose
sub verbose
{
    my ($self,$msg) = @_;
    if ($verbose) {
        print $msg, "\n";
    }
}


### close
sub close
{
    my $self = shift;

    close $self->{logfh};
}


### EOP ###
1;


