package Benno;
use strict;


=head1 id2box($bennoid)

    Returns the box id of the given bennoid.

=cut
sub id2box
{
    my ($class,$bennoid) = @_;

    my ($box_id) = $bennoid =~ m!^([^:]+?):!;
    $box_id or die "ERROR: incorrect boxid\n";

    return $box_id;
}


=head1 id2path($bennoid[$pathconfig])

    Returns the path representation of the given bennoid.

    $pathconfig optional (default 3:2)

=cut
sub id2path
{
    my ($class,$bennoid,$pathconfig) = @_;
    my $path;

    if ($pathconfig =~ /^3:2$/) {
        my ($box,$p1,$p2,$p3,$p4) = $bennoid =~ /^(.+?):(..)(..)(..)(.+)$/;
        $path = "$box/$p1/$p2/$p3/$p4";
    }
    elsif ($pathconfig =~ /\d:\d/) {
        die "ERROR: Invalid pathconfig $pathconfig\n";
    }
    else {
        my ($box,$p1) = $bennoid =~ /^(.+?):(.+)$/;
        $path = "$box/$p1";
    }

    return $path;
}



=head1 config($configfile)

    Read configuration from configfile.

    Returns config hash with config variables.

=cut
# Read conf file
# _very_ simple config file parser
#
# Config format:   var = val
#
sub config
{
    my ($class,$configfile) = @_;

    $configfile or $configfile = $class; # call as ->config() or ::config()
 
    my %config;
    open my $ch , $configfile or die "Cannot open $configfile: $!";
    foreach my $line (<$ch>) {
        next if $line =~ /^$/;
        next if $line =~ /^#/;
        $line =~ s/\R//g;
        my ($var,$val) = split(/=/, $line,2);
        # strip ws
        $var =~ s/\s//g;
        $val =~ s/^\s+//g;
        $val =~ s/\s+$//g;
        if ($val =~ /^\</) {  # read file content
            $val = Benno->_file_value($val);
        }

        $config{$var} = $val;
    }
    close $ch;
    return %config;
}

=head1 run_as($userid)

    Run command as user.

=cut
sub run_as {
    my ($package,$user) = @_;
    unless( $user ){
        print STDERR __PACKAGE__." must be imported with user to run as.\n";
        exit 1;
    }
    if (($< == 0) || (getpwuid($<) eq $user)) {
        my ($uid,$gid) = (getpwnam($user))[2,3];
        $( = $gid;
        $) = $gid;
        $> = $uid;
        $< = $uid;
    }
    else {
        print STDERR "Program must be run as $user or root.\n";
        exit 2;
    }
}


# read config value from file
sub _file_value
{ 
    my ($class,$configval) = @_;
    my $retval;

    (my $file = $configval) =~ s/^\<//;
    eval {
        local $/;
        open(my $fh, '<', $file) or die "Cannot read $file: $!\n";
        $retval = <$fh>;
        close($fh);
    };
    if ($@) {
        print STDERR "NOTE $@";
        return $configval;
    }
    chomp $retval;
    return $retval;
}   


### EOP ###
1;
