package Benno::Boxstate;
use XML::LibXML;
use Benno::Box;
use strict;


sub new
{
    my $class = shift;
    my ($filename)  = @_;

    my $self = {
        filename => $filename,
        boxes => {},
    };
    bless $self, $class;
    
    $self->_init($self);

    return $self;
}


sub add_box
{
    my ($self,$Box) = @_;

    my $boxid = $Box->id;
    $self->{boxes}->{$boxid} = $Box;
}


sub get_box
{
    my ($self,$boxid) = @_;

    return $self->{boxes}->{$boxid};
}


sub get_boxes
{
    my ($self) = @_;

    my @retlist;
    foreach my $boxid (keys %{$self->{boxes}}) {
        push @retlist, $self->{boxes}->{$boxid};
    }

    return @retlist;
}


sub repodir
{
    my ($self) = @_;

    my ($repodir) = $self->{filename} =~ m!(.*?)/[^/]+?$!;

    return $repodir;
}


sub _init
{
    my ($self) = @_;

    my $dom;
    eval {
        $dom = XML::LibXML->load_xml(location => $self->{filename});
    };
    if ($@) {
        die "Cannot parse $self->{filename}: $!\n";
    }

    # load boxes
    my $boxes;
    foreach my $node ($dom->findnodes('/boxstate/box')) {
        my $snodes = $node->findnodes('box/config/storage');
        my $driver = $snodes->shift->getAttribute('driver');

        my $Box = new Benno::Box($node->getAttribute('identifier'));
        $Box->set_config('storage',$driver);
        if ($driver =~ /^s3/i) {
            my $endpoint = $node->findvalue('box/config/storage/endpoint');
            $endpoint =~ s!^https://!!;
            $endpoint =~ s!/.*$!!;
            $Box->set_config('endpoint',$endpoint);
            $Box->set_config('authKeyId',$node->findvalue('box/config/storage/authentication/authKeyId'));
            $Box->set_config('authKey',$node->findvalue('box/config/storage/authentication/authKey'));
            $Box->set_config('boxName',$node->findvalue('box/config/storage/boxName'));
            $Box->set_config('bennoPath',$node->findvalue('box/config/storage/bennoPath'));
            $Box->set_config('bucket',$node->findvalue('box/config/storage/bucket'));
            $self->add_box($Box);
        }
        else {
            $Box->set_config('subdirs',$node->findvalue('box/config/storage/subdirs'));
            $Box->set_config('dirlength',$node->findvalue('box/config/storage/dirlength'));
            $Box->set_config('compression',$node->findvalue('box/config/compression'));


            $self->add_box($Box);
        }
    }
}

### EOP ###
1;

