package Benno::Boxstate::S3;
use parent 'Benno::Boxstate';
use XML::LibXML;
use Benno::Box;
use strict;


sub _init
{
    my ($self) = @_;

    my $dom = XML::LibXML->load_xml(location => $self->{filename});

    # load boxes
    my $boxes;
    foreach my $node ($dom->findnodes('/boxstate/box')) {
        my $Box = new Benno::Box($node->getAttribute('identifier'));
        my $endpoint = $node->findvalue('box/config/storage/endpoint');
        $endpoint =~ s!^https://!!;
        $endpoint =~ s!/.*$!!;
        $Box->set_config('endpoint',$endpoint);
        $Box->set_config('authKeyId',$node->findvalue('box/config/storage/authentication/authKeyId'));
        $Box->set_config('authKey',$node->findvalue('box/config/storage/authentication/authKey'));
        $Box->set_config('boxName',$node->findvalue('box/config/storage/boxName'));
        $Box->set_config('bennoPath',$node->findvalue('box/config/storage/bennoPath'));
        $Box->set_config('bucket',$node->findvalue('box/config/storage/bucket'));
        $Box->set_config('compression',$node->findvalue('box/config/compression'));
        $self->add_box($Box);
    }
}


### EOP ###
1;
