package Benno::Config;

use XML::LibXML;
use strict;
use Benno::Container;

sub new
{
    my $class = shift;
    my ($id)  = @_;
    my $self = {
        conainers => {},
    };
    bless $self, $class;

    return $self;
}


sub addContainer
{
    my ($self,$Cnt) = @_;

    $self->{containers}->{$Cnt->{id}} = $Cnt;
}


sub getContainers 
{
    my ($self) = @_;

    my @retlist;
    foreach my $cid (keys %{$self->{contianers}}) {
        push @retlist, $self->{containers}->{$cid};
    }

    return @retlist;
}


sub _init
{
    my ($self) = @_;

    my $dom = XML::LibXML->load_xml(location => $self->{filename});

    # load Container
    foreach my $xml ($dom->findnodes('/simplecontainer')) {
        $self->addContainer(new Benno::Container($xml));
    }
}





### EOP ###
1;
